/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.actions.AbstractStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.commands.CreateInitialStateCommand;
import org.eclipse.emf.henshin.statespace.impl.ModelImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CreateInitialStateAction
extends AbstractStateSpaceAction {
    private int[] location;

    public void run(IAction action) {
        Shell shell = this.getExplorer().getSite().getShell();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Load resource");
        dialog.setMessage("Select the resource to load:");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        dialog.setInput((Object)root);
        URI uri = this.getExplorer().getStateSpaceManager().getStateSpace().eResource().getURI().trimSegments(1);
        IResource container = root.findMember(uri.toPlatformString(true));
        if (container != null) {
            dialog.setInitialSelection((Object)container);
        }
        dialog.open();
        if (this.location == null) {
            int[] nArray = new int[3];
            nArray[0] = 50;
            nArray[1] = 50;
            this.location = nArray;
        }
        if (dialog.getReturnCode() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IFile) {
                    this.load((IFile)object);
                }
                ++n2;
            }
        }
    }

    private void load(IFile file) {
        StateSpaceManager manager = this.getExplorer().getStateSpaceManager();
        StateSpace stateSpace = manager.getStateSpace();
        ResourceSet resourceSet = stateSpace.eResource().getResourceSet();
        URI absolute = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        URI relative = absolute.deresolve(stateSpace.eResource().getURI());
        try {
            Resource resource = resourceSet.getResource(absolute, true);
            resource.setURI(relative);
            ModelImpl model = new ModelImpl(resource);
            CreateInitialStateCommand command = new CreateInitialStateCommand((Model)model, manager);
            command.setLocation(this.location);
            this.getExplorer().executeCommand(command);
        }
        catch (Throwable t) {
            Shell shell = this.getExplorer().getSite().getShell();
            MessageDialog.openError((Shell)shell, (String)"Create Initial State", (String)("Error creating initial state for " + file + ": " + t.getMessage()));
        }
    }

    public void setLocation(int ... location) {
        this.location = location;
    }
}

