/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.EdgeActionHelper;
import org.eclipse.emf.henshin.diagram.edit.actions.NodeActionHelper;
import org.eclipse.emf.henshin.diagram.navigator.HenshinNavigatorGroup;
import org.eclipse.emf.henshin.diagram.navigator.HenshinNavigatorItem;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.diagram.providers.HenshinParserProvider;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapterFactory;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class HenshinNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider,
IColorProvider {
    private HenshinItemProviderAdapterFactory adapterFactory = new HenshinItemProviderAdapterFactory();

    static {
        HenshinDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        HenshinDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof HenshinNavigatorItem && !this.isOwnView(((HenshinNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof HenshinNavigatorGroup) {
            HenshinNavigatorGroup group = (HenshinNavigatorGroup)((Object)element);
            return HenshinDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof HenshinNavigatorItem) {
            HenshinNavigatorItem navigatorItem = (HenshinNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (HenshinVisualIDRegistry.getVisualID(view)) {
            case 3002: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/emf/2010/Henshin?Attribute", HenshinElementTypes.Attribute_3002);
            }
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/emf/2010/Henshin?TransformationSystem", HenshinElementTypes.TransformationSystem_1000);
            }
            case 3001: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/emf/2010/Henshin?Node", HenshinElementTypes.Node_3001);
            }
            case 2001: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/emf/2010/Henshin?Rule", HenshinElementTypes.Rule_2001);
            }
            case 4001: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/emf/2010/Henshin?Edge", HenshinElementTypes.Edge_4001);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = HenshinDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && HenshinElementTypes.isKnownElementType(elementType)) {
            image = HenshinElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof HenshinNavigatorGroup) {
            HenshinNavigatorGroup group = (HenshinNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof HenshinNavigatorItem) {
            HenshinNavigatorItem navigatorItem = (HenshinNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        EObject element = view.getElement();
        if (element != null && element.eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        Adapter adapter = this.adapterFactory.createAdapter((Notifier)element);
        if (adapter instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getText((Object)element);
        }
        return this.getUnknownElementText(view);
    }

    private String getTransformationSystem_1000Text(View view) {
        TransformationSystem domainModelElement = (TransformationSystem)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        HenshinDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getRule_2001Text(View view) {
        IParser parser = HenshinParserProvider.getParser(HenshinElementTypes.Rule_2001, (EObject)(view.getElement() != null ? view.getElement() : view), HenshinVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        HenshinDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getNode_3001Text(View view) {
        IParser parser = HenshinParserProvider.getParser(HenshinElementTypes.Node_3001, (EObject)(view.getElement() != null ? view.getElement() : view), HenshinVisualIDRegistry.getType(5002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        HenshinDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5002");
        return "";
    }

    private String getAttribute_3002Text(View view) {
        IParser parser = HenshinParserProvider.getParser(HenshinElementTypes.Attribute_3002, (EObject)(view.getElement() != null ? view.getElement() : view), HenshinVisualIDRegistry.getType(3002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        HenshinDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3002");
        return "";
    }

    private String getEdge_4001Text(View view) {
        IParser parser = HenshinParserProvider.getParser(HenshinElementTypes.Edge_4001, (EObject)(view.getElement() != null ? view.getElement() : view), HenshinVisualIDRegistry.getType(6001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        HenshinDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6001");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "Henshin".equals(HenshinVisualIDRegistry.getModelID(view));
    }

    public Color getForeground(Object element) {
        HenshinNavigatorItem item;
        if (element instanceof HenshinNavigatorItem && this.isOwnView((item = (HenshinNavigatorItem)((Object)element)).getView())) {
            Action action;
            View view = item.getView();
            if (view.getElement() instanceof Node && (action = NodeActionHelper.INSTANCE.getAction((Node)view.getElement())) != null) {
                return action.getType().getColor();
            }
            if (view.getElement() instanceof Edge && (action = EdgeActionHelper.INSTANCE.getAction((Edge)view.getElement())) != null) {
                return action.getType().getColor();
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

