/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class AmalgamationEditHelper {
    public static final String MULTI_RULE_NAME_PREFIX = "multi_";

    public static AmalgamationUnit getAmalgamation(Rule rule) {
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(rule);
        if (amalgamation == null) {
            amalgamation = AmalgamationEditHelper.getAmalgamationFromMultiRule(rule);
        }
        return amalgamation;
    }

    public static AmalgamationUnit getAmalgamationFromKernelRule(Rule kernel) {
        TransformationSystem system = kernel.getTransformationSystem();
        if (system == null) {
            return null;
        }
        String name = kernel.getName();
        if (name == null) {
            return null;
        }
        for (TransformationUnit unit : system.getTransformationUnits()) {
            AmalgamationUnit amalgamation;
            if (!(unit instanceof AmalgamationUnit) || !name.equals(unit.getName()) || (amalgamation = (AmalgamationUnit)unit).getKernelRule() != kernel) continue;
            return amalgamation;
        }
        return null;
    }

    public static AmalgamationUnit getAmalgamationFromMultiRule(Rule rule) {
        TransformationSystem system = rule.getTransformationSystem();
        if (system == null) {
            return null;
        }
        for (Rule kernel : system.getRules()) {
            AmalgamationUnit amalgamation;
            if (kernel == rule || (amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(kernel)) == null || !amalgamation.getMultiRules().contains((Object)rule)) continue;
            return amalgamation;
        }
        return null;
    }

    public static boolean isMultiRule(Rule rule) {
        return AmalgamationEditHelper.getAmalgamationFromMultiRule(rule) != null;
    }

    public static GraphElement getPreimageInKernelRule(GraphElement element, AmalgamationUnit amalgamation) {
        Graph graph = element.getGraph();
        if (graph == null) {
            return null;
        }
        Rule rule = graph.getContainerRule();
        if (rule == null) {
            return null;
        }
        if (graph == rule.getLhs()) {
            return (GraphElement)HenshinMappingUtil.getOrigin((Object)element, (List)amalgamation.getLhsMappings());
        }
        if (graph == rule.getRhs()) {
            return (GraphElement)HenshinMappingUtil.getOrigin((Object)element, (List)amalgamation.getRhsMappings());
        }
        throw new IllegalArgumentException("Element is neither part of the LHS nor the RHS");
    }

    public static Rule getMultiRule(Rule kernel, String name) {
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(kernel);
        if (amalgamation == null) {
            return null;
        }
        name = MULTI_RULE_NAME_PREFIX + name;
        for (Rule multi : amalgamation.getMultiRules()) {
            if (!name.equals(multi.getName())) continue;
            return multi;
        }
        return null;
    }

    public static String getMultiRuleName(Rule rule, AmalgamationUnit amalgamation) {
        if (rule.getName() == null) {
            return null;
        }
        String name = rule.getName();
        if (name.startsWith(MULTI_RULE_NAME_PREFIX)) {
            name = name.substring(MULTI_RULE_NAME_PREFIX.length());
        }
        if (name.equals(amalgamation.getName())) {
            name = "";
        }
        return name;
    }

    public static Rule createMultiRule(AmalgamationUnit amalgamation, String name) {
        Rule multiRule = HenshinFactory.eINSTANCE.createRule();
        multiRule.setName(MULTI_RULE_NAME_PREFIX + name);
        amalgamation.getMultiRules().add((Object)multiRule);
        amalgamation.getKernelRule().getTransformationSystem().getRules().add((Object)multiRule);
        return multiRule;
    }

    public static Rule createDefaultMultiRule(AmalgamationUnit amalgamation) {
        return AmalgamationEditHelper.createMultiRule(amalgamation, amalgamation.getName());
    }

    public static Rule getDefaultMultiRule(Rule kernel) {
        if (kernel.getName() == null) {
            return null;
        }
        return AmalgamationEditHelper.getMultiRule(kernel, kernel.getName());
    }

    public static void renameKernelRule(Rule kernel, String newName) {
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(kernel);
        Rule multi = AmalgamationEditHelper.getDefaultMultiRule(kernel);
        if (amalgamation != null) {
            amalgamation.setName(newName);
        }
        if (multi != null) {
            multi.setName(MULTI_RULE_NAME_PREFIX + newName);
        }
        kernel.setName(newName);
    }

    public static boolean isTrivialMultiRule(Rule multi, AmalgamationUnit amalgamation) {
        ArrayList elements = new ArrayList();
        elements.addAll(multi.getLhs().getNodes());
        elements.addAll(multi.getLhs().getEdges());
        elements.addAll(multi.getRhs().getNodes());
        elements.addAll(multi.getRhs().getEdges());
        for (GraphElement element : elements) {
            if (AmalgamationEditHelper.getPreimageInKernelRule(element, amalgamation) != null) continue;
            return false;
        }
        return true;
    }

    public static void cleanUpAmalagamation(AmalgamationUnit amalgamation) {
        if (amalgamation == null || amalgamation.getKernelRule() == null) {
            return;
        }
        TransformationSystem system = amalgamation.getKernelRule().getTransformationSystem();
        if (system == null) {
            return;
        }
        int i = 0;
        while (i < amalgamation.getMultiRules().size()) {
            Rule multi = (Rule)amalgamation.getMultiRules().get(i);
            if (AmalgamationEditHelper.isTrivialMultiRule(multi, amalgamation)) {
                amalgamation.getMultiRules().remove(i--);
                system.getRules().remove((Object)multi);
            }
            ++i;
        }
        if (amalgamation.getMultiRules().isEmpty() && system.getTransformationUnits().contains((Object)amalgamation)) {
            amalgamation.setKernelRule(null);
            system.getTransformationUnits().remove((Object)amalgamation);
        }
    }

    public static void cleanUpAmalagamation(Rule rule) {
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamation(rule);
        if (amalgamation != null) {
            AmalgamationEditHelper.cleanUpAmalagamation(amalgamation);
        }
    }
}

