/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;

public class NodeCreateCommand
extends EditElementCommand {
    public static final String TYPE_PARAMETER_KEY = "henshin_node_type";

    public NodeCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Rule rule = (Rule)this.getElementToEdit();
        if (rule.getLhs() == null) {
            Graph lhs = HenshinFactory.eINSTANCE.createGraph();
            lhs.setName("LHS");
            rule.setLhs(lhs);
        }
        if (rule.getRhs() == null) {
            Graph rhs = HenshinFactory.eINSTANCE.createGraph();
            rhs.setName("RHS");
            rule.setRhs(rhs);
        }
        Node lhsNode = HenshinFactory.eINSTANCE.createNode();
        Node rhsNode = HenshinFactory.eINSTANCE.createNode();
        rule.getLhs().getNodes().add((Object)lhsNode);
        rule.getRhs().getNodes().add((Object)rhsNode);
        Mapping mapping = HenshinFactory.eINSTANCE.createMapping();
        mapping.setOrigin(lhsNode);
        mapping.setImage(rhsNode);
        rule.getMappings().add((Object)mapping);
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        if (request.getParameter(TYPE_PARAMETER_KEY) instanceof EClass) {
            EClass type = (EClass)request.getParameter(TYPE_PARAMETER_KEY);
            lhsNode.setType(type);
            rhsNode.setType(type);
        }
        View ruleView = RootObjectEditHelper.findRuleView(rule);
        RootObjectEditHelper.updateRootContainment(ruleView, lhsNode);
        this.doConfigure(lhsNode, monitor, info);
        request.setNewElement((EObject)lhsNode);
        return CommandResult.newOKCommandResult((Object)lhsNode);
    }

    protected void doConfigure(Node newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

