/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFContainerDescription;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFFillLayoutDescription;
import org.eclipse.eef.EEFGridLayoutDescription;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFLayoutDescription;
import org.eclipse.eef.EEF_FILL_LAYOUT_ORIENTATION;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFControlSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EEFContainerLifecycleManager
implements IEEFLifecycleManager {
    private EEFContainerDescription description;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private EditingContextAdapter contextAdapter;
    private List<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();

    public EEFContainerLifecycleManager(EEFContainerDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        this.description = description;
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.contextAdapter = editingContextAdapter;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite composite = null;
        GridData gridData = null;
        if (this.description.eContainer() instanceof EEFGroupDescription) {
            widgetFactory.createLabel(parent, "");
            widgetFactory.createLabel(parent, "");
        }
        if (this.isBorderedContainer()) {
            String borderLabel = this.getBorderLabel();
            composite = widgetFactory.createGroup(parent, borderLabel);
            gridData = new GridData(4, 0x1000000, true, false);
        } else {
            composite = widgetFactory.createComposite(parent);
            gridData = new GridData(768);
        }
        composite.setLayoutData((Object)gridData);
        GridLayout compositeLayout = new GridLayout(1, true);
        compositeLayout.marginWidth = 1;
        EEFLayoutDescription layout = this.description.getLayout();
        if (layout instanceof EEFFillLayoutDescription) {
            EEFFillLayoutDescription fillLayoutDescription = (EEFFillLayoutDescription)layout;
            if (fillLayoutDescription.getOrientation() == EEF_FILL_LAYOUT_ORIENTATION.HORIZONTAL) {
                compositeLayout = new GridLayout(this.description.getControls().size(), false);
                compositeLayout.marginWidth = 1;
            }
        } else if (layout instanceof EEFGridLayoutDescription) {
            EEFGridLayoutDescription gridLayoutDescription = (EEFGridLayoutDescription)layout;
            compositeLayout = new GridLayout(gridLayoutDescription.getNumberOfColumns(), gridLayoutDescription.isMakeColumnsWithEqualWidth());
            compositeLayout.marginWidth = 1;
        }
        composite.setLayout((Layout)compositeLayout);
        EEFControlSwitch eefControlSwitch = new EEFControlSwitch(this.interpreter, this.contextAdapter);
        EList controls = this.description.getControls();
        for (EEFControlDescription eefControlDescription : controls) {
            this.lifecycleManagers.addAll(eefControlSwitch.doCreate(composite, formContainer, eefControlDescription, this.variableManager));
        }
    }

    protected String getBorderLabel() {
        return "";
    }

    protected boolean isBorderedContainer() {
        return false;
    }

    @Override
    public void aboutToBeShown() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::aboutToBeShown);
    }

    @Override
    public void refresh() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::refresh);
    }

    @Override
    public void aboutToBeHidden() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::aboutToBeHidden);
    }

    @Override
    public void dispose() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::dispose);
    }
}

