/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.eef.properties.ui.api.IEEFSectionDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTypeMapper;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EEFTabbedPropertyRegistryClassSectionFilter {
    private IEEFTypeMapper typeMapper;

    public EEFTabbedPropertyRegistryClassSectionFilter(IEEFTypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public boolean appliesToSelection(IEEFSectionDescriptor descriptor, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (descriptor.getEnablesFor() != -1 && structuredSelection.size() != descriptor.getEnablesFor()) {
                return false;
            }
            Object[] objects = structuredSelection.toArray();
            IFilter filter = descriptor.getFilter();
            if (filter != null) {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (!filter.select(object)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            HashSet effectiveTypes = new HashSet();
            Object[] objectArray = objects;
            int n = objects.length;
            int n3 = 0;
            while (n3 < n) {
                Object object = objectArray[n3];
                Class<?> remapType = object.getClass();
                if (this.typeMapper != null) {
                    remapType = this.typeMapper.mapType(object);
                }
                if (effectiveTypes.add(remapType) && !this.appliesToEffectiveType(descriptor, remapType)) {
                    return false;
                }
                ++n3;
            }
        } else if (descriptor.getFilter() != null) {
            return descriptor.getFilter().select((Object)selection);
        }
        return true;
    }

    private boolean appliesToEffectiveType(IEEFSectionDescriptor descriptor, Class<?> inputClass) {
        List<String> classTypes = this.getClassTypes(inputClass);
        List<String> sectionInputTypes = descriptor.getInputTypes();
        for (String type : sectionInputTypes) {
            if (!classTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getClassTypes(Class<?> target) {
        ArrayList<String> result = new ArrayList<String>();
        List<Class<?>> classes = this.computeClassOrder(target);
        for (Class<?> aClass : classes) {
            result.add(aClass.getName());
        }
        result.addAll(this.computeInterfaceNameOrder(classes));
        return result;
    }

    private List<Class<?>> computeClassOrder(Class<?> target) {
        ArrayList result = new ArrayList();
        Class<?> clazz = target;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List<String> computeInterfaceNameOrder(List<Class<?>> classes) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap seen = new HashMap();
        for (Class<?> aClass : classes) {
            this.internalComputeInterfaceOrder(aClass.getInterfaces(), result, seen);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void internalComputeInterfaceOrder(Class<?>[] interfaces, List<String> result, Map<Class<?>, Class<?>> seen) {
        void var5_6;
        ArrayList newInterfaces = new ArrayList(seen.size());
        boolean bl = false;
        while (var5_6 < interfaces.length) {
            Class<?> interfac = interfaces[var5_6];
            if (seen.get(interfac) == null) {
                result.add(interfac.getName());
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++var5_6;
        }
        for (Class clazz : newInterfaces) {
            this.internalComputeInterfaceOrder(clazz.getInterfaces(), result, seen);
        }
    }
}

