/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;

public abstract class AbstractRegistryEventListener
implements IRegistryEventListener {
    private final String namespace;
    private final String extensionPointID;

    public AbstractRegistryEventListener(String namespace, String extensionPointID) {
        this.namespace = namespace;
        this.extensionPointID = extensionPointID;
    }

    public void readRegistry(IExtensionRegistry extensionRegistry) {
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(this.namespace, this.extensionPointID);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                this.processConfigurationElement(configurationElement, Action.ADD);
                ++n2;
            }
        }
    }

    private void processConfigurationElement(IConfigurationElement configurationElement, Action action) {
        boolean isValid = this.readConfigurationElement(configurationElement, action);
        if (isValid) {
            IConfigurationElement[] children;
            IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childConfigurationElement = iConfigurationElementArray[n2];
                this.processConfigurationElement(childConfigurationElement, action);
                ++n2;
            }
        }
    }

    private boolean readConfigurationElement(IConfigurationElement configurationElement, Action action) {
        boolean isValid = false;
        if (this.validateConfigurationElement(configurationElement)) {
            if (Action.ADD == action) {
                isValid = this.processAddition(configurationElement);
            } else if (Action.REMOVE == action) {
                isValid = this.processRemoval(configurationElement);
            }
        }
        return isValid;
    }

    protected abstract boolean validateConfigurationElement(IConfigurationElement var1);

    protected abstract boolean processAddition(IConfigurationElement var1);

    protected abstract boolean processRemoval(IConfigurationElement var1);

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointID)) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    this.processConfigurationElement(configurationElement, Action.ADD);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointID)) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    this.processConfigurationElement(configurationElement, Action.REMOVE);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    protected static enum Action {
        ADD,
        REMOVE;

    }
}

