/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.common.api;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.eef.common.api.preferences.EEFCommonPreferences;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.internal.Messages;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;

public abstract class AbstractEEFEclipsePlugin
extends EMFPlugin.EclipsePlugin {
    private String bundleSymbolicName;

    public AbstractEEFEclipsePlugin(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    private void doLog(int severity, String message, Exception exception) {
        String messageToLog = message;
        if (messageToLog == null && exception != null) {
            messageToLog = exception.getMessage();
        }
        Status status = new Status(severity, this.bundleSymbolicName, messageToLog, (Throwable)exception);
        this.getLog().log((IStatus)status);
    }

    public void blank(EAttribute expression) {
        String message = MessageFormat.format(Messages.AbstractEEFEclipsePlugin_BlankExpression, expression.getName(), expression.getEContainingClass().getName());
        this.error(message);
    }

    public void diagnostic(String expression, Diagnostic diagnostic) {
        String ls = System.getProperty("line.separator");
        StringBuilder messageToLog = new StringBuilder();
        if (!Util.isBlank(diagnostic.getMessage())) {
            messageToLog.append(diagnostic.getMessage());
            messageToLog.append(ls);
        }
        List children = diagnostic.getChildren();
        for (Diagnostic childDiagnostic : children) {
            if (Util.isBlank(childDiagnostic.getMessage())) continue;
            messageToLog.append(childDiagnostic.getMessage());
            messageToLog.append(ls);
        }
        String message = MessageFormat.format(Messages.AbstractEEFEclipsePlugin_InvalidEvaluation, expression, messageToLog);
        Status status = new Status(diagnostic.getSeverity(), this.bundleSymbolicName, message, diagnostic.getException());
        this.getLog().log((IStatus)status);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Exception exception) {
        if (exception instanceof CoreException) {
            this.getLog().log(((CoreException)exception).getStatus());
        } else {
            this.doLog(4, message, exception);
        }
    }

    public void warning(String message) {
        this.warning(message, null);
    }

    public void warning(String message, Exception exception) {
        if (exception instanceof CoreException) {
            this.getLog().log(((CoreException)exception).getStatus());
        } else {
            this.doLog(2, message, exception);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Exception exception) {
        if (exception instanceof CoreException) {
            this.getLog().log(((CoreException)exception).getStatus());
        } else {
            this.doLog(1, message, exception);
        }
    }

    public void debug(String message) {
        if (EEFCommonPreferences.isDebugEnabled()) {
            this.info(message);
        }
    }
}

