/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.eef.properties.ui.api.IEEFSectionDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTypeMapper;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemRegistry;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertySectionItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertySectionSorter;
import org.eclipse.eef.properties.ui.legacy.internal.legacy2eef.EEFLegacyTypeMapper;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class LegacyPropertySectionRegistry
implements IItemRegistry {
    private Map<String, List<IItemDescriptor>> id2descriptors = new HashMap<String, List<IItemDescriptor>>();

    public List<IEEFSectionDescriptor> getPropertySections(String contributorId, String tabId) {
        HashMap<String, IEEFSectionDescriptor> eefSectionDescriptors = new HashMap<String, IEEFSectionDescriptor>();
        Collection<LegacyPropertySectionItemDescriptor> values = new ArrayList();
        ISectionDescriptorProvider sectionDescriptorProvider = EEFPropertiesUiLegacyPlugin.getImplementation().getTabbedPropertyContributorRegistry().getSectionDescriptorProvider(contributorId);
        if (sectionDescriptorProvider != null) {
            ISectionDescriptor[] iSectionDescriptorArray;
            ISectionDescriptor[] iSectionDescriptorArray2 = iSectionDescriptorArray = sectionDescriptorProvider.getSectionDescriptors();
            int n = iSectionDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISectionDescriptor sectionDescriptor = iSectionDescriptorArray2[n2];
                ITypeMapper typeMapper = EEFPropertiesUiLegacyPlugin.getImplementation().getTabbedPropertyContributorRegistry().getTypeMapper(contributorId);
                EEFLegacyTypeMapper eefTypeMapper = null;
                if (typeMapper != null) {
                    eefTypeMapper = new EEFLegacyTypeMapper(typeMapper);
                }
                LegacyPropertySectionItemDescriptor legacySectionDescriptor = new LegacyPropertySectionItemDescriptor(sectionDescriptor, (IEEFTypeMapper)eefTypeMapper);
                values.add(legacySectionDescriptor);
                ++n2;
            }
        }
        if (values.isEmpty()) {
            values = this.id2descriptors.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
        for (IItemDescriptor iItemDescriptor : values) {
            String tab;
            if (!(iItemDescriptor instanceof IEEFSectionDescriptor)) continue;
            String legacyContributorId = null;
            if (iItemDescriptor instanceof LegacyPropertySectionItemDescriptor) {
                legacyContributorId = ((LegacyPropertySectionItemDescriptor)iItemDescriptor).getContributionId();
            }
            String sectionTargetTabId = tab = ((IEEFSectionDescriptor)iItemDescriptor).getTargetTab();
            if ((legacyContributorId == null || !legacyContributorId.equals(contributorId)) && legacyContributorId != null || !tabId.equals(sectionTargetTabId)) continue;
            String key = String.valueOf(sectionTargetTabId) + iItemDescriptor.getId();
            eefSectionDescriptors.put(key, (IEEFSectionDescriptor)iItemDescriptor);
        }
        List<IEEFSectionDescriptor> list = new LegacyPropertySectionSorter().sortSectionsByAfterSection(eefSectionDescriptors.values());
        return new ArrayList<IEEFSectionDescriptor>(list);
    }

    @Override
    public IItemDescriptor add(IItemDescriptor descriptor) {
        List descriptors = this.id2descriptors.getOrDefault(descriptor.getId(), new ArrayList());
        boolean result = descriptors.add(descriptor);
        this.id2descriptors.put(descriptor.getId(), descriptors);
        if (result) {
            return descriptor;
        }
        return null;
    }

    @Override
    public boolean remove(String id) {
        List descriptors = Optional.ofNullable(this.id2descriptors.remove(id)).orElseGet(ArrayList::new);
        return !descriptors.isEmpty();
    }

    @Override
    public void clear() {
        this.id2descriptors.clear();
    }
}

