/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api.widgets;

import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.controllers.IEEFController;
import org.eclipse.eef.core.api.controllers.IInvalidValidationRuleResult;
import org.eclipse.eef.core.api.controllers.IValidationRuleResult;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public abstract class AbstractEEFLifecycleManager
implements IEEFLifecycleManager {
    protected IEEFFormContainer container;

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        this.container = formContainer;
    }

    @Override
    public void aboutToBeShown() {
        this.getController().onValidation(validationRuleResults -> {
            IMessageManager messageManager = this.container.getForm().getMessageManager();
            for (IValidationRuleResult validationRuleResult : validationRuleResults) {
                if (validationRuleResult instanceof IInvalidValidationRuleResult) {
                    IInvalidValidationRuleResult result = (IInvalidValidationRuleResult)validationRuleResult;
                    if (this.getValidationControl() != null) {
                        messageManager.addMessage((Object)result.getValidationRule(), result.getMessage(), (Object)result.getData(), result.getSeverity(), this.getValidationControl());
                        continue;
                    }
                    messageManager.addMessage((Object)result.getValidationRule(), result.getMessage(), (Object)result.getData(), result.getSeverity());
                    continue;
                }
                if (this.getValidationControl() != null) {
                    messageManager.removeMessage((Object)validationRuleResult.getValidationRule(), this.getValidationControl());
                    continue;
                }
                messageManager.removeMessage((Object)validationRuleResult.getValidationRule());
            }
        });
    }

    protected abstract IEEFController getController();

    protected abstract Control getValidationControl();

    @Override
    public void refresh() {
        this.getController().refresh();
    }

    @Override
    public void aboutToBeHidden() {
        this.getController().removeValidationConsumer();
    }
}

