/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.osgi.framework.Bundle;

public class FileProvider {
    private static FileProvider instance;
    private Map<File, String> file2plugin = new HashMap<File, String>();
    private Map<File, String> file2path = new HashMap<File, String>();

    public static FileProvider getDefault() {
        if (instance == null) {
            instance = new FileProvider();
        }
        return instance;
    }

    public Optional<File> getFile(IPath fullPath) {
        Optional<File> optionalFile = Optional.empty();
        if (fullPath != null && fullPath.segmentCount() > 0) {
            Optional<IFile> iFile = FileProvider.findFile(fullPath);
            if (iFile.isPresent()) {
                optionalFile = iFile.map(IResource::getLocation).map(IPath::toFile);
            } else {
                String pluginId = fullPath.segment(0);
                optionalFile = this.getFile(pluginId, fullPath.removeFirstSegments(1));
            }
        }
        return optionalFile;
    }

    private Optional<File> getFile(String pluginId, IPath relativePath) {
        return this.getFile(pluginId, relativePath, true);
    }

    private Optional<File> getFile(String pluginId, IPath relativePath, boolean requiredSearch) {
        return Optional.ofNullable(Platform.getBundle((String)pluginId)).flatMap(bundle -> {
            Optional<Object> optionalFile = Optional.ofNullable(bundle.getEntry(relativePath.toString())).flatMap(url -> this.getFileFromUrl((URL)url, pluginId, relativePath, (Bundle)bundle));
            if (!optionalFile.isPresent() && requiredSearch) {
                optionalFile = this.getFileFromBundles(relativePath, (Bundle)bundle);
            }
            return optionalFile;
        });
    }

    private Optional<File> getFileFromUrl(URL url, String pluginId, IPath relativePath, Bundle bundle) {
        File file = new File(FileProvider.transformToAbsolutePath(url));
        if (file.exists()) {
            if (!this.file2plugin.containsKey(file)) {
                this.file2plugin.put(file, pluginId);
                this.file2path.put(file, relativePath.toString());
                Enumeration allProperties = bundle.findEntries(relativePath.removeLastSegments(1).toString(), "*.properties", true);
                while (allProperties != null && allProperties.hasMoreElements()) {
                    Optional.ofNullable(allProperties.nextElement()).filter(URL.class::isInstance).map(URL.class::cast).ifPresent(propertyFileURL -> {
                        File propertyFile = new File(FileProvider.transformToAbsolutePath(propertyFileURL));
                        if (propertyFile.exists()) {
                            this.file2plugin.put(propertyFile, pluginId);
                        }
                    });
                }
            }
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private Optional<File> getFileFromBundles(IPath relativePath, Bundle bundle) {
        String requiredBundles = (String)bundle.getHeaders().get("Require-Bundle");
        if (requiredBundles != null) {
            StringTokenizer st = new StringTokenizer(requiredBundles, ",");
            while (st.hasMoreTokens()) {
                Optional<File> optionalScriptFile;
                String id = st.nextToken().trim();
                int iDot = id.indexOf(59);
                if (iDot > -1) {
                    id = id.substring(0, iDot).trim();
                }
                if (id.length() <= 0 || !(optionalScriptFile = this.getFile(id, relativePath, false)).isPresent()) continue;
                return optionalScriptFile;
            }
        }
        return Optional.empty();
    }

    private static Optional<IFile> findFile(IPath path) {
        return FileProvider.findResource(path).filter(IFile.class::isInstance).map(IFile.class::cast);
    }

    private static Optional<IResource> findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().exists(path)) {
            return Optional.ofNullable(workspace.getRoot().findMember(path));
        }
        return Optional.empty();
    }

    private static String transformToAbsolutePath(URL url) {
        String absolutePath;
        try {
            URL transformedUrl = FileLocator.toFileURL((URL)url);
            File file = new File(transformedUrl.getFile());
            absolutePath = file.getAbsolutePath();
        }
        catch (IOException e) {
            absolutePath = "";
            EEFIdeUiPlugin.getPlugin().error(e.getMessage(), e);
        }
        return absolutePath;
    }
}

