/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.common.api.AbstractEEFEclipsePlugin;
import org.eclipse.eef.ide.api.extensions.AbstractRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.IItemDescriptor;
import org.eclipse.eef.ide.api.extensions.IItemRegistry;
import org.eclipse.eef.ide.api.extensions.impl.DescriptorRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.impl.ItemRegistry;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManagerProvider;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EEFIdeUiPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.eef.ide.ui";
    public static final EEFIdeUiPlugin INSTANCE = new EEFIdeUiPlugin();
    private static Implementation plugin;

    public EEFIdeUiPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends AbstractEEFEclipsePlugin {
        private static final String EEF_LIFECYCLE_MANAGER_PROVIDER_EXTENSION_POINT = "eefLifecycleManagerProvider";
        private ImageRegistry imageRegistry;
        private IItemRegistry<IEEFLifecycleManagerProvider> eefLifecycleManagerProviderRegistry;
        private AbstractRegistryEventListener eefLifecycleManagerProviderListener;

        public Implementation() {
            super(EEFIdeUiPlugin.PLUGIN_ID);
            plugin = this;
            this.imageRegistry = this.createImageRegistry();
            this.imageRegistry.put("icons/full/help.gif", this.getImageDescriptor("icons/full/help.gif"));
            this.imageRegistry.put("icons/full/create.gif", this.getImageDescriptor("icons/full/create.gif"));
            this.imageRegistry.put("icons/full/search.gif", this.getImageDescriptor("icons/full/search.gif"));
            this.imageRegistry.put("icons/full/unset.gif", this.getImageDescriptor("icons/full/unset.gif"));
            this.imageRegistry.put("icons/full/up.gif", this.getImageDescriptor("icons/full/up.gif"));
            this.imageRegistry.put("icons/full/down.gif", this.getImageDescriptor("icons/full/down.gif"));
            this.imageRegistry.put("icons/full/info.gif", this.getImageDescriptor("icons/full/info.gif"));
            this.imageRegistry.put("icons/full/warning.gif", this.getImageDescriptor("icons/full/warning.gif"));
            this.imageRegistry.put("icons/full/error.gif", this.getImageDescriptor("icons/full/error.gif"));
            this.imageRegistry.put("icons/full/fix.gif", this.getImageDescriptor("icons/full/fix.gif"));
            this.imageRegistry.put("icons/full/permission_denied.gif", this.getImageDescriptor("icons/full/permission_denied.gif"));
            this.imageRegistry.put("icons/full/permission_granted_to_current_user_exclusively.gif", this.getImageDescriptor("icons/full/permission_granted_to_current_user_exclusively.gif"));
        }

        private ImageRegistry createImageRegistry() {
            if (Display.getCurrent() != null) {
                return new ImageRegistry(Display.getCurrent());
            }
            if (PlatformUI.isWorkbenchRunning()) {
                return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            }
            throw new SWTError(22);
        }

        public ImageDescriptor getImageDescriptor(String path) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)EEFIdeUiPlugin.PLUGIN_ID, (String)path);
        }

        public Image getImage(URL url) {
            Image image = this.imageRegistry.get(url.toString());
            if (image == null) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                this.imageRegistry.put(url.toString(), imageDescriptor);
                image = this.imageRegistry.get(url.toString());
            }
            return image;
        }

        public ImageRegistry getImageRegistry() {
            return this.imageRegistry;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.eefLifecycleManagerProviderRegistry = new ItemRegistry();
            this.eefLifecycleManagerProviderListener = new DescriptorRegistryEventListener(EEFIdeUiPlugin.PLUGIN_ID, EEF_LIFECYCLE_MANAGER_PROVIDER_EXTENSION_POINT, this.eefLifecycleManagerProviderRegistry);
            registry.addListener((IRegistryEventListener)this.eefLifecycleManagerProviderListener, "org.eclipse.eef.ide.ui.eefLifecycleManagerProvider");
            this.eefLifecycleManagerProviderListener.readRegistry(registry);
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.eefLifecycleManagerProviderListener);
            this.eefLifecycleManagerProviderListener = null;
            this.eefLifecycleManagerProviderRegistry = null;
        }

        public IEEFLifecycleManagerProvider getEEFLifecycleManagerProvider(EEFControlDescription eefControlDescription) {
            for (IItemDescriptor itemDescriptor : this.eefLifecycleManagerProviderRegistry.getItemDescriptors()) {
                IEEFLifecycleManagerProvider eefLifecycleManagerProvider = (IEEFLifecycleManagerProvider)itemDescriptor.getItem();
                if (!eefLifecycleManagerProvider.canHandle(eefControlDescription)) continue;
                return eefLifecycleManagerProvider;
            }
            return null;
        }
    }
}

