/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.eef.EEFButtonDescription;
import org.eclipse.eef.EEFCheckboxDescription;
import org.eclipse.eef.EEFContainerDescription;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFCustomWidgetDescription;
import org.eclipse.eef.EEFDynamicMappingFor;
import org.eclipse.eef.EEFDynamicMappingIf;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFLabelDescription;
import org.eclipse.eef.EEFListDescription;
import org.eclipse.eef.EEFRadioDescription;
import org.eclipse.eef.EEFSelectDescription;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManagerProvider;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.widgets.EEFButtonLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFCheckboxLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFContainerLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFHyperlinkLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFLabelLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFListLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFRadioLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFSelectLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFTextLifecycleManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.widgets.Composite;

public class EEFControlSwitch {
    private IInterpreter interpreter;
    private EditingContextAdapter contextAdapter;

    public EEFControlSwitch(IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        this.interpreter = interpreter;
        this.contextAdapter = contextAdapter;
    }

    public List<IEEFLifecycleManager> doCreate(Composite parent, IEEFFormContainer formContainer, EEFControlDescription controlDescription, IVariableManager variableManager) {
        ArrayList<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();
        if (controlDescription instanceof EEFContainerDescription) {
            IVariableManager childVariableManager = variableManager.createChild();
            IEEFLifecycleManager eefContainerLifecycleManager = null;
            IEEFLifecycleManagerProvider eefLifecycleManagerProvider = EEFIdeUiPlugin.getPlugin().getEEFLifecycleManagerProvider(controlDescription);
            eefContainerLifecycleManager = eefLifecycleManagerProvider != null ? eefLifecycleManagerProvider.getLifecycleManager(controlDescription, childVariableManager, this.interpreter, this.contextAdapter) : new EEFContainerLifecycleManager((EEFContainerDescription)controlDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefContainerLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefContainerLifecycleManager);
        } else if (controlDescription instanceof EEFWidgetDescription) {
            lifecycleManagers.addAll(this.createWidgetControl(parent, formContainer, (EEFWidgetDescription)controlDescription, variableManager.createChild()));
        } else if (controlDescription instanceof EEFDynamicMappingFor) {
            lifecycleManagers.addAll(this.createDynamicMappingControl(parent, formContainer, (EEFDynamicMappingFor)controlDescription, variableManager));
        }
        return lifecycleManagers;
    }

    private List<IEEFLifecycleManager> createWidgetControl(Composite parent, IEEFFormContainer formContainer, EEFWidgetDescription widgetDescription, IVariableManager childVariableManager) {
        ArrayList<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();
        IEEFLifecycleManagerProvider eefLifecycleManagerProvider = EEFIdeUiPlugin.getPlugin().getEEFLifecycleManagerProvider((EEFControlDescription)widgetDescription);
        if (eefLifecycleManagerProvider != null) {
            IEEFLifecycleManager eefLifecycleManager = eefLifecycleManagerProvider.getLifecycleManager((EEFControlDescription)widgetDescription, childVariableManager, this.interpreter, this.contextAdapter);
            if (eefLifecycleManager != null) {
                eefLifecycleManager.createControl(parent, formContainer);
                lifecycleManagers.add(eefLifecycleManager);
            }
        } else if (widgetDescription instanceof EEFCustomWidgetDescription) {
            String message = MessageFormat.format(Messages.EEFIdeUiPlugin_lifecycleManagerNotFound, widgetDescription.getIdentifier());
            EEFIdeUiPlugin.getPlugin().error(message);
        } else if (widgetDescription instanceof EEFTextDescription) {
            EEFTextDescription eefTextDescription = (EEFTextDescription)widgetDescription;
            EEFTextLifecycleManager eefTextLifecycleManager = new EEFTextLifecycleManager(eefTextDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefTextLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefTextLifecycleManager);
        } else if (widgetDescription instanceof EEFLabelDescription) {
            EEFLabelDescription eefLabelDescription = (EEFLabelDescription)widgetDescription;
            EEFLabelLifecycleManager eefLabelLifecycleManager = new EEFLabelLifecycleManager(eefLabelDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefLabelLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefLabelLifecycleManager);
        } else if (widgetDescription instanceof EEFSelectDescription) {
            EEFSelectDescription eefSelectDescription = (EEFSelectDescription)widgetDescription;
            EEFSelectLifecycleManager eefSelectLifecycleManager = new EEFSelectLifecycleManager(eefSelectDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefSelectLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefSelectLifecycleManager);
        } else if (widgetDescription instanceof EEFRadioDescription) {
            EEFRadioDescription eefRadioDescription = (EEFRadioDescription)widgetDescription;
            EEFRadioLifecycleManager eefRadioLifecycleManager = new EEFRadioLifecycleManager(eefRadioDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefRadioLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefRadioLifecycleManager);
        } else if (widgetDescription instanceof EEFCheckboxDescription) {
            EEFCheckboxDescription eefCheckboxDescription = (EEFCheckboxDescription)widgetDescription;
            EEFCheckboxLifecycleManager eefCheckboxLifecycleManager = new EEFCheckboxLifecycleManager(eefCheckboxDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefCheckboxLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefCheckboxLifecycleManager);
        } else if (widgetDescription instanceof EEFButtonDescription) {
            EEFButtonDescription eefButtonDescription = (EEFButtonDescription)widgetDescription;
            EEFButtonLifecycleManager eefButtonLifecycleManager = new EEFButtonLifecycleManager(eefButtonDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefButtonLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefButtonLifecycleManager);
        } else if (widgetDescription instanceof EEFListDescription) {
            EEFListDescription eefListDescription = (EEFListDescription)widgetDescription;
            EEFListLifecycleManager eefListLifecycleManager = new EEFListLifecycleManager(eefListDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefListLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefListLifecycleManager);
        } else if (widgetDescription instanceof EEFHyperlinkDescription) {
            EEFHyperlinkDescription eefHyperlinkDescription = (EEFHyperlinkDescription)widgetDescription;
            EEFHyperlinkLifecycleManager eefHyperlinkLifecycleManager = new EEFHyperlinkLifecycleManager(eefHyperlinkDescription, childVariableManager, this.interpreter, this.contextAdapter);
            eefHyperlinkLifecycleManager.createControl(parent, formContainer);
            lifecycleManagers.add(eefHyperlinkLifecycleManager);
        }
        return lifecycleManagers;
    }

    private List<IEEFLifecycleManager> createDynamicMappingControl(Composite parent, IEEFFormContainer formContainer, EEFDynamicMappingFor dynamicMappingFor, IVariableManager variableManager) {
        ArrayList<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();
        String iterableExpression = dynamicMappingFor.getIterableExpression();
        EAttribute iterableEAttribute = EefPackage.Literals.EEF_DYNAMIC_MAPPING_FOR__ITERABLE_EXPRESSION;
        String iterator = dynamicMappingFor.getIterator();
        EAttribute ifExpressionEAttribute = EefPackage.Literals.EEF_DYNAMIC_MAPPING_IF__PREDICATE_EXPRESSION;
        Object iterableExpressionResult = EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)variableManager).logIfBlank(iterableEAttribute).evaluate(iterableExpression);
        for (Object object : Util.asIterable((Object)iterableExpressionResult, Object.class)) {
            HashMap<String, Object> switchExpressionVariables = new HashMap<String, Object>();
            switchExpressionVariables.put("self", variableManager.getVariables().get("self"));
            switchExpressionVariables.put("input", variableManager.getVariables().get("input"));
            switchExpressionVariables.put(iterator, object);
            EList dynamicMappingIfs = dynamicMappingFor.getIfs();
            for (EEFDynamicMappingIf dynamicMappingIf : dynamicMappingIfs) {
                Boolean isValid = (Boolean)EvalFactory.of((IInterpreter)this.interpreter, switchExpressionVariables).logIfInvalidType(Boolean.class).logIfBlank(ifExpressionEAttribute).evaluate(dynamicMappingIf.getPredicateExpression());
                if (isValid == null || !isValid.booleanValue()) continue;
                IVariableManager childVariableManager = variableManager.createChild();
                childVariableManager.put(iterator, object);
                lifecycleManagers.addAll(this.createWidgetControl(parent, formContainer, dynamicMappingIf.getWidget(), childVariableManager));
            }
        }
        return lifecycleManagers;
    }
}

