/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFSelectDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFSelectController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.internal.EEFIdePlugin;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class EEFSelectLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final Object NO_VALUE = new Object(){

        public String toString() {
            return "<null>";
        }
    };
    private EEFSelectDescription description;
    private ComboViewer comboViewer;
    private Combo combo;
    private IEEFSelectController controller;
    private SelectionListener selectionListener;
    private MouseListener mouseListener;
    private ISelection referenceValue;

    public EEFSelectLifecycleManager(EEFSelectDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.comboViewer = new ComboViewer(parent, 8);
        this.combo = this.comboViewer.getCombo();
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.combo.setLayoutData((Object)gridData);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new EEFSelectLabelProvider());
        this.comboViewer.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createSelectController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.combo;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!EEFSelectLifecycleManager.this.container.isRenderingInProgress()) {
                    IStatus result;
                    IStructuredSelection selection = EEFSelectLifecycleManager.this.getStructuredSelection((StructuredViewer)EEFSelectLifecycleManager.this.comboViewer);
                    Object newValue = selection.getFirstElement();
                    if (newValue == NO_VALUE) {
                        newValue = null;
                    }
                    if ((result = EEFSelectLifecycleManager.this.controller.updateValue(newValue)) != null && result.getSeverity() == 4) {
                        EEFIdePlugin.INSTANCE.log((Object)result);
                        EEFSelectLifecycleManager.this.comboViewer.setSelection(EEFSelectLifecycleManager.this.referenceValue);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.combo.addSelectionListener(this.selectionListener);
        this.mouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                EEFSelectLifecycleManager.this.controller.computeCandidates();
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        this.combo.addMouseListener(this.mouseListener);
        this.controller.onNewValue((IConsumer)new IConsumer<Object>(){

            public void apply(Object value) {
                if (!(EEFSelectLifecycleManager.this.combo.isDisposed() || EEFSelectLifecycleManager.this.combo.getText() != null && EEFSelectLifecycleManager.this.combo.getText().equals(value))) {
                    StructuredSelection selection = value != null ? new StructuredSelection(value) : null;
                    EEFSelectLifecycleManager.this.referenceValue = (ISelection)selection;
                    EEFSelectLifecycleManager.this.comboViewer.setSelection(EEFSelectLifecycleManager.this.referenceValue, true);
                    if (!EEFSelectLifecycleManager.this.combo.isEnabled()) {
                        EEFSelectLifecycleManager.this.combo.setEnabled(true);
                    }
                }
            }
        });
        this.controller.onNewCandidates((IConsumer)new IConsumer<List<Object>>(){

            public void apply(List<Object> value) {
                ISelection selection = EEFSelectLifecycleManager.this.comboViewer.getSelection();
                if (!EEFSelectLifecycleManager.this.combo.isDisposed()) {
                    if (value != null) {
                        Object[] candidates = value.toArray();
                        int i = 0;
                        while (i < candidates.length) {
                            if (candidates[i] == null) {
                                candidates[i] = NO_VALUE;
                            }
                            ++i;
                        }
                        EEFSelectLifecycleManager.this.comboViewer.setInput((Object)candidates);
                    } else {
                        EEFSelectLifecycleManager.this.comboViewer.setInput(null);
                    }
                    EEFSelectLifecycleManager.this.comboViewer.setSelection(selection, true);
                    if (!EEFSelectLifecycleManager.this.combo.isEnabled()) {
                        EEFSelectLifecycleManager.this.combo.setEnabled(true);
                    }
                }
                EEFSelectLifecycleManager.this.combo.setCursor(new Cursor((Device)Display.getCurrent(), 0));
            }
        });
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.combo.isDisposed()) {
            this.combo.removeSelectionListener(this.selectionListener);
            this.combo.removeMouseListener(this.mouseListener);
        }
        this.controller.removeNewValueConsumer();
        this.controller.removeNewCandidatesConsumer();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.combo.setEnabled(this.isEnabled());
    }

    private final class EEFSelectLabelProvider
    extends LabelProvider {
        private EEFSelectLabelProvider() {
        }

        public String getText(Object element) {
            String expression = EEFSelectLifecycleManager.this.description.getCandidateDisplayExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_SELECT_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("self", EEFSelectLifecycleManager.this.variableManager.getVariables().get("self"));
            variables.put("candidate", element);
            return (String)EvalFactory.of((IInterpreter)EEFSelectLifecycleManager.this.interpreter, variables).logIfInvalidType(String.class).logIfBlank(eAttribute).evaluate(expression);
        }
    }
}

