/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.eef.codegen.flow.ConditionalStep;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.StepWithInput;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowContext;
import org.eclipse.emf.eef.codegen.launcher.EEFCodegenLauncher;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workflow
extends StepWithInput {
    private Map<String, Step> steps;
    private Shell shell;
    private boolean prepared;
    private boolean canExecute;

    public Workflow(String name, Shell shell) {
        super(name);
        this.steps = new LinkedHashMap<String, Step>();
        this.shell = shell;
        this.prepared = false;
    }

    public Workflow(String name, Shell shell, Map<String, Step> steps) {
        super(name);
        this.steps = steps;
        this.shell = shell;
        this.prepared = false;
    }

    @Override
    public void setContext(WorkflowContext context) {
        super.setContext(context);
        for (Step step : this.steps.values()) {
            step.setContext(context);
        }
    }

    public void addStep(String key, Step step) {
        if (this.context == null) {
            this.context = new WorkflowContext();
        }
        step.setContext(this.context);
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        step.setResourceSet(this.resourceSet);
        this.steps.put(key, step);
    }

    @Override
    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
            for (Step step : this.steps.values()) {
                step.setResourceSet(this.resourceSet);
            }
        }
        return this.resourceSet;
    }

    @Override
    public void setResourceSet(ResourceSet resourceSet) {
        super.setResourceSet(resourceSet);
        for (Step step : this.steps.values()) {
            step.setResourceSet(resourceSet);
        }
    }

    @Override
    public List<WizardPage> getInputPages() {
        ArrayList<WizardPage> flowPages = new ArrayList<WizardPage>();
        for (Step step : this.steps.values()) {
            if (step instanceof ConditionalStep) {
                step = ((ConditionalStep)step).condition() ? ((ConditionalStep)step).getThenStep() : ((ConditionalStep)step).getElseStep();
            }
            if (!(step instanceof StepWithInput)) continue;
            flowPages.addAll(((StepWithInput)step).getInputPages());
        }
        return flowPages;
    }

    public boolean prepare() {
        this.canExecute = true;
        if (this.getInputPages().size() > 0) {
            Wizard prepareWizard = new Wizard(){

                public void addPages() {
                    for (WizardPage page : Workflow.this.getInputPages()) {
                        this.addPage((IWizardPage)page);
                    }
                }

                public boolean performFinish() {
                    Workflow.this.canExecute = true;
                    return true;
                }

                public boolean performCancel() {
                    Workflow.this.canExecute = false;
                    return true;
                }
            };
            WizardDialog wDialog = new WizardDialog(this.shell, (IWizard)prepareWizard);
            wDialog.open();
        }
        this.prepared = true;
        return this.canExecute;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        assert (this.prepared) : "Workflow must be prepared before execution";
        monitor.beginTask(this.name, this.steps.size());
        for (String key : this.steps.keySet()) {
            IStatus execute;
            monitor.subTask(key);
            Step step = this.steps.get(key);
            if (step instanceof ConditionalStep) {
                step = ((ConditionalStep)step).condition() ? ((ConditionalStep)step).getThenStep() : ((ConditionalStep)step).getElseStep();
            }
            if (step.validateExecution() && !(execute = step.execute(monitor)).isOK()) {
                EEFCodegenLauncher.getDefault().logError((Exception)execute.getException());
                return execute;
            }
            monitor.worked(1);
        }
        return Status.OK_STATUS;
    }
}

