/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.runtime.ui.widgets.EEFFeatureEditorDialog;
import org.eclipse.emf.eef.runtime.ui.widgets.IPropertiesFilteredWidget;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FlatReferencesTable
extends Composite
implements ISelectionProvider,
IPropertiesFilteredWidget {
    private Text selection;
    protected Button editer;
    protected List<ViewerFilter> filters;
    protected List<ViewerFilter> brFilters;
    private List<ISelectionChangedListener> listeners;
    protected ILabelProvider delegatedLabelProvider;
    protected ILabelProvider listLabelProvider;
    private ButtonsModeEnum button_mode = ButtonsModeEnum.BROWSE;
    protected EObject editedElement;
    protected EStructuralFeature feature;
    protected Object input;
    protected EList<?> result;
    private EReference containingFeature;

    public FlatReferencesTable(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.selection = new Text((Composite)this, 2048);
        GridData selectionData = new GridData(768);
        this.selection.setLayoutData((Object)selectionData);
        this.selection.setEditable(false);
        EditingUtils.setEEFtype((Control)this.selection, "eef::FlatReferencesTable::field");
        this.editer = new Button((Composite)this, 8);
        this.editer.setText(EEFRuntimeUIMessages.EObjectFlatComboViewer_add_button);
        this.filters = new ArrayList<ViewerFilter>();
        this.brFilters = new ArrayList<ViewerFilter>();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.editer.addSelectionListener((SelectionListener)this.getSelectionAdapter());
        EditingUtils.setEEFtype((Control)this.editer, "eef::FlatReferencesTable::browsebutton");
    }

    protected SelectionAdapter getSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (FlatReferencesTable.this.button_mode) {
                    case BROWSE: {
                        if (!(FlatReferencesTable.this.input instanceof ReferencesTableSettings)) break;
                        List<Object> currentValues = Arrays.asList(((ReferencesTableSettings)FlatReferencesTable.this.input).getValue());
                        Object choiceOfValues2 = ((ReferencesTableSettings)FlatReferencesTable.this.input).choiceOfValues(null);
                        ArrayList<Object> cloneOfValues = new ArrayList<Object>();
                        if (choiceOfValues2 instanceof List) {
                            cloneOfValues.addAll((List)choiceOfValues2);
                        } else {
                            cloneOfValues.add(choiceOfValues2);
                        }
                        EEFFeatureEditorDialog dialog = new EEFFeatureEditorDialog(FlatReferencesTable.this.getParent().getShell(), EEFRuntimeUIMessages.FlatReferencesTable_featureEditor_title, FlatReferencesTable.this.delegatedLabelProvider, currentValues, cloneOfValues, false, true, FlatReferencesTable.this.filters, FlatReferencesTable.this.brFilters);
                        int open = dialog.open();
                        if (open != 0) break;
                        FlatReferencesTable.this.selectionChanged((ISelection)new StructuredSelection(dialog.getResult()));
                        FlatReferencesTable.this.refresh();
                        break;
                    }
                }
            }
        };
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.delegatedLabelProvider = provider;
        if (this.listLabelProvider == null) {
            this.listLabelProvider = new ILabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                    FlatReferencesTable.this.delegatedLabelProvider.addListener(listener);
                }

                public void dispose() {
                    FlatReferencesTable.this.delegatedLabelProvider.dispose();
                }

                public Image getImage(Object element) {
                    return FlatReferencesTable.this.delegatedLabelProvider.getImage(element);
                }

                public String getText(Object element) {
                    if (element instanceof List) {
                        StringBuilder result = new StringBuilder("");
                        List collec = (List)element;
                        if (collec.size() > 0) {
                            result.append(FlatReferencesTable.this.delegatedLabelProvider.getText(collec.get(0)));
                            if (collec.size() > 1) {
                                int i = 1;
                                while (i < collec.size()) {
                                    result.append(", ");
                                    result.append(FlatReferencesTable.this.delegatedLabelProvider.getText(collec.get(i)));
                                    ++i;
                                }
                            }
                        }
                        return result.toString();
                    }
                    return FlatReferencesTable.this.delegatedLabelProvider.getText(element);
                }

                public boolean isLabelProperty(Object element, String property) {
                    return FlatReferencesTable.this.delegatedLabelProvider.isLabelProperty(element, property);
                }

                public void removeListener(ILabelProviderListener listener) {
                    FlatReferencesTable.this.delegatedLabelProvider.removeListener(listener);
                }
            };
        }
    }

    public void setButtonMode(ButtonsModeEnum button_mode) {
        this.button_mode = button_mode;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        if (this.input != input) {
            this.input = input;
        }
        this.refresh();
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.selection, id);
        EditingUtils.setID((Control)this.editer, id);
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.selection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        throw new UnsupportedOperationException(EEFRuntimeUIMessages.FlatReferencesTable_nothing_to_do);
    }

    public void setSelection(ISelection pSelection) {
        throw new UnsupportedOperationException(EEFRuntimeUIMessages.FlatReferencesTable_nothing_to_do);
    }

    public void refresh() {
        if (this.input instanceof ReferencesTableSettings) {
            List<Object> values = Arrays.asList(((ReferencesTableSettings)this.input).getValue());
            if (this.listLabelProvider != null) {
                this.selection.setText(this.listLabelProvider.getText(values));
            } else {
                StringBuilder result = new StringBuilder("");
                if (values.size() > 0) {
                    result.append(values.get(0).toString());
                    if (values.size() > 1) {
                        int i = 1;
                        while (i < values.size()) {
                            result.append(", ");
                            result.append(values.get(i).toString());
                            ++i;
                        }
                    }
                }
                this.selection.setText(result.toString());
            }
        } else {
            this.selection.setText("");
        }
    }

    protected void selectionChanged(ISelection selection) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ISelectionChangedListener nextListener : this.listeners) {
                nextListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            }
        }
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        this.filters.remove(filter);
    }

    public void addBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.add(filter);
    }

    public void removeBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.remove(filter);
    }

    public void resetFilters() {
        this.filters.clear();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editer.setEnabled(enabled);
    }
}

