/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.viewers.Viewer;

public class AdvancedEEFEditorContentProvider
extends AdapterFactoryContentProvider {
    private List<Object> choiceOfValues = new ArrayList<Object>();
    private boolean eefInput = false;

    public AdvancedEEFEditorContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof EEFEditorSettings) {
            this.choiceOfValues.clear();
            this.computeChoiceOfValues(newInput);
            this.eefInput = true;
        } else {
            this.eefInput = false;
        }
    }

    public Object[] getElements(Object object) {
        if (object instanceof EEFEditorSettings) {
            BasicEList resources = new BasicEList((Collection)((EEFEditorSettings)object).getSource().eResource().getResourceSet().getResources());
            resources.retainAll(this.choiceOfValues);
            return resources.toArray();
        }
        return super.getElements(object);
    }

    public Object[] getChildren(Object object) {
        if (this.eefInput) {
            Object[] children = super.getChildren(object);
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.choiceOfValues.contains(child)) {
                    result.add(child);
                }
                ++n2;
            }
            return result.toArray();
        }
        return super.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        if (this.eefInput) {
            return this.getChildren(object).length > 0;
        }
        return super.hasChildren(object);
    }

    private void computeChoiceOfValues(Object input) {
        Object choiceOfValues2 = ((EEFEditorSettings)input).choiceOfValues(this.adapterFactory);
        if (choiceOfValues2 instanceof Collection) {
            for (Object next : (Collection)choiceOfValues2) {
                while (next != null) {
                    if (next instanceof EObject) {
                        this.choiceOfValues.add(next);
                        EObject eContainer = ((EObject)next).eContainer();
                        if (eContainer == null) {
                            next = ((EObject)next).eResource();
                            continue;
                        }
                        next = eContainer;
                        continue;
                    }
                    if (next instanceof Resource) {
                        this.choiceOfValues.add(next);
                        next = null;
                        continue;
                    }
                    if (!"".equals(next)) continue;
                    this.choiceOfValues.add(next);
                    next = null;
                }
            }
        }
    }
}

