/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.components;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionPartProvider;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.impl.components.StandardPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.impl.parts.CompositePropertiesEditionPart;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionPartProviderService;

public abstract class SinglePartPropertiesEditingComponent
extends StandardPropertiesEditionComponent {
    protected EObject semanticObject;
    protected IPropertiesEditionPart editingPart;
    protected Object repositoryKey;
    protected Object partKey;

    public SinglePartPropertiesEditingComponent(PropertiesEditingContext editingContext, EObject semanticObject, String editing_mode) {
        this.semanticObject = semanticObject;
        this.editingContext = editingContext;
        if ("Live".equals(editing_mode)) {
            this.semanticAdapter = this.initializeSemanticAdapter();
        }
        this.editing_mode = editing_mode;
        this.activate();
    }

    public void activate() {
        if (this.semanticAdapter != null) {
            this.semanticObject.eAdapters().add((Object)this.semanticAdapter);
        }
    }

    public void deactivate() {
        if (this.semanticAdapter != null) {
            this.semanticObject.eAdapters().remove((Object)this.semanticAdapter);
        }
    }

    private String partID() {
        return this.parts[0];
    }

    public Object translatePart(String key) {
        if (this.partID().equals(key)) {
            return this.partKey;
        }
        return super.translatePart(key);
    }

    public void setPropertiesEditionPart(Object key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        if (key == this.partKey) {
            this.editingPart = propertiesEditionPart;
            if (this.semanticAdapter != null) {
                this.semanticAdapter.setPart(this.editingPart);
            }
        }
    }

    public PropertiesEditingContext getEditingContext() {
        return this.editingContext;
    }

    public Diagnostic validate() {
        Diagnostic validate = Diagnostic.OK_INSTANCE;
        validate = EEFRuntimePlugin.getEEFValidator().validate(this.semanticObject);
        return validate;
    }

    public void dispose() {
        this.deactivate();
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.semanticObject != null && this.partID().equals(key)) {
            IPropertiesEditionPartProvider provider;
            if (this.editingPart == null && (provider = PropertiesEditionPartProviderService.getInstance().getProvider(this.repositoryKey)) != null) {
                this.editingPart = provider.getPropertiesEditionPart(this.partKey, kind, this);
                this.addListener(this.editingPart);
                if (this.semanticAdapter != null) {
                    this.semanticAdapter.setPart(this.editingPart);
                }
            }
            return this.editingPart;
        }
        return null;
    }

    public String getTabText(String p_key) {
        return this.editingPart.getTitle();
    }

    public boolean isAccessible(Object key) {
        if (this.editingPart != null && ((CompositePropertiesEditionPart)this.editingPart).getComposer() != null) {
            return ((CompositePropertiesEditionPart)this.editingPart).getComposer().isVisible(key);
        }
        return false;
    }
}

