/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.generators.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.ui.generators.common.GenerateAll;
import org.eclipse.emf.eef.codegen.ui.generators.common.ImportOrganizer;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateEEFAction
extends Action
implements IObjectActionDelegate {
    private Shell shell;
    private IWorkbenchSite site;
    protected List<IFile> selectedFiles = new ArrayList<IFile>();
    protected List<EEFGenModel> eefGenModels = new ArrayList<EEFGenModel>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.site = targetPart.getSite();
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        try {
            if (this.selectedFiles != null) {
                this.eefGenModels = this.initEEFGenModel();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                if (AbstractGenerateEEFAction.this.eefGenModels != null) {
                                    for (EEFGenModel eefGenModel : AbstractGenerateEEFAction.this.eefGenModels) {
                                        IContainer target = AbstractGenerateEEFAction.this.getGenContainer(eefGenModel);
                                        if (target == null) continue;
                                        int count = 2;
                                        if (eefGenModel.getEditionContexts() != null) {
                                            count += eefGenModel.getEditionContexts().size() * 11;
                                        }
                                        if (eefGenModel.getViewsRepositories() != null) {
                                            count += eefGenModel.getViewsRepositories().size() * 5;
                                        }
                                        monitor.beginTask("Generating EEF Architecture", count);
                                        final GenerateAll generator = new GenerateAll(target, eefGenModel);
                                        generator.doGenerate(monitor);
                                        for (IContainer nextContainer : generator.getGenerationTargets()) {
                                            nextContainer.refreshLocal(2, monitor);
                                        }
                                        monitor.worked(1);
                                        if (!EEFUtils.isBundleLoaded((String)"org.eclipse.jdt.core")) continue;
                                        monitor.beginTask("Organize imports", 1);
                                        Display.getDefault().asyncExec(new Runnable(){

                                            public void run() {
                                                ImportOrganizer.organizeImports(AbstractGenerateEEFAction.this.site, generator.getGenerationTargets());
                                            }
                                        });
                                    }
                                }
                            }
                            catch (IOException e) {
                                EEFCodegenPlugin.getDefault().logError(e);
                                monitor.done();
                                AbstractGenerateEEFAction.this.selectedFiles.clear();
                                AbstractGenerateEEFAction.this.eefGenModels.clear();
                            }
                            catch (CoreException e) {
                                EEFCodegenPlugin.getDefault().logError((Exception)((Object)e));
                                monitor.done();
                                AbstractGenerateEEFAction.this.selectedFiles.clear();
                                AbstractGenerateEEFAction.this.eefGenModels.clear();
                            }
                        }
                        finally {
                            monitor.done();
                            AbstractGenerateEEFAction.this.selectedFiles.clear();
                            AbstractGenerateEEFAction.this.eefGenModels.clear();
                        }
                    }
                };
                new ProgressMonitorDialog(this.shell).run(true, true, runnable);
            }
        }
        catch (InvocationTargetException e) {
            EEFCodegenPlugin.getDefault().logError(e);
        }
        catch (InterruptedException e) {
            EEFCodegenPlugin.getDefault().logWarning(e);
        }
        catch (IOException e) {
            EEFCodegenPlugin.getDefault().logError(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.eefGenModels.clear();
        if (selection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)selection;
            for (Object selectedElement : sSelection.toList()) {
                if (!(selectedElement instanceof IFile)) continue;
                this.selectedFiles.add((IFile)selectedElement);
            }
        }
    }

    protected abstract List<EEFGenModel> initEEFGenModel() throws IOException;

    public IContainer getGenContainer(EEFGenModel eefGenModel) throws IOException {
        if (eefGenModel != null && eefGenModel.getGenDirectory() != null) {
            IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(eefGenModel.getGenDirectory()));
            return target;
        }
        return null;
    }
}

