/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IFormPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.parts.ISWTPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.impl.parts.CompositePropertiesEditionPart;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionContentProvider;
import org.eclipse.emf.eef.runtime.ui.viewers.filters.PropertiesEditionPartFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PropertiesEditionViewer
extends StructuredViewer {
    private FormToolkit toolkit;
    protected CTabFolder folder = null;
    protected Composite control;
    protected boolean dynamicTabHeader = true;
    private int kind;
    private List<ViewerFilter> filters;
    private boolean initState = false;
    protected ResourceSet allResources;
    private ItemListener listener;
    protected ScrolledComposite scroll;

    public PropertiesEditionViewer(Composite container, ResourceSet allResources, int style, int kind) {
        this.control = new Composite(container, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.control.setLayoutData((Object)new GridData(1808));
        this.scroll = new ScrolledComposite(this.control, 768);
        this.folder = new CTabFolder((Composite)this.scroll, style);
        this.folder.setSimple(false);
        this.allResources = allResources;
        this.kind = kind;
        this.scroll.setContent((Control)this.folder);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        this.listener = new ItemListener();
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditionViewer.this.listener.updateControlListener();
            }
        });
        this.control.addControlListener((ControlListener)this.listener);
    }

    public PropertiesEditionViewer(Composite container, ResourceSet allResources, int kind) {
        this(container, allResources, 2048, kind);
    }

    public Control getControl() {
        return this.control;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public void setToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
        toolkit.adapt(this.control);
        toolkit.adapt((Composite)this.scroll);
        toolkit.adapt((Composite)this.folder);
    }

    public boolean isInitializing() {
        return this.initState;
    }

    public void setDynamicTabHeader(boolean dynamic) {
        this.dynamicTabHeader = dynamic;
    }

    public void addPropertiesListener(IPropertiesEditionListener listener) {
        if (this.getContentProvider() != null) {
            ((PropertiesEditionContentProvider)this.getContentProvider()).addPropertiesListener(listener);
        }
    }

    protected Object getRoot() {
        return this.getEObjectFromInput();
    }

    public EObject getEObjectFromInput() {
        EObject result = null;
        if (this.getInput() instanceof EObject) {
            result = (EObject)this.getInput();
        } else if (this.getInput() instanceof PropertiesEditingContext) {
            result = ((PropertiesEditingContext)this.getInput()).getEObject();
        }
        return result;
    }

    public ViewerFilter[] getFilters() {
        if (this.filters == null) {
            return new ViewerFilter[0];
        }
        ViewerFilter[] result = new ViewerFilter[this.filters.size()];
        this.filters.toArray(result);
        return result;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<ViewerFilter>();
        }
        this.filters.add(filter);
        this.refresh();
    }

    public void removeFilter(ViewerFilter filter) {
        Assert.isNotNull((Object)filter);
        if (this.filters != null) {
            Iterator<ViewerFilter> i = this.filters.iterator();
            while (i.hasNext()) {
                ViewerFilter o = i.next();
                if (o != filter) continue;
                i.remove();
                this.refresh();
                if (this.filters.size() == 0) {
                    this.filters = null;
                }
                return;
            }
        }
    }

    public void setFilters(ViewerFilter[] filters) {
        if (filters.length == 0) {
            this.resetFilters();
        } else {
            this.filters = new ArrayList<ViewerFilter>(Arrays.asList(filters));
            this.refresh();
        }
    }

    public void resetFilters() {
        if (this.filters != null) {
            this.filters = null;
            this.refresh();
        }
    }

    private boolean selectPart(String key, IPropertiesEditionPart propertiesEditionPart) {
        boolean result = true;
        if (this.filters != null) {
            boolean select = true;
            int j = 0;
            while (j < this.filters.size()) {
                ViewerFilter viewerFilter = this.filters.get(j);
                if (viewerFilter instanceof PropertiesEditionPartFilter && !(select = viewerFilter.select((Viewer)this, (Object)key, (Object)propertiesEditionPart))) {
                    result = false;
                    break;
                }
                ++j;
            }
        }
        return result;
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        if (this.getContentProvider() != null) {
            return ((PropertiesEditionContentProvider)this.getContentProvider()).validateValue(event);
        }
        return null;
    }

    public ISelection getSelection() {
        Object root = this.getRoot();
        if (root != null) {
            return new StructuredSelection(root);
        }
        return new StructuredSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    protected List getSelectionFromWidget() {
        return null;
    }

    protected void internalRefresh(Object element) {
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.initControl();
    }

    public void reveal(Object element) {
    }

    public CompositePropertiesEditionPart getSelectedPart() {
        PropertiesEditionContentProvider propertiesEditionContentProvider = (PropertiesEditionContentProvider)this.getContentProvider();
        String selectedPartTitle = this.folder.getSelection().getText();
        return (CompositePropertiesEditionPart)propertiesEditionContentProvider.getPropertiesEditionPart(this.kind, selectedPartTitle);
    }

    protected void initControl() {
        if (this.getContentProvider() != null) {
            PropertiesEditionContentProvider propertiesEditionProvider = (PropertiesEditionContentProvider)this.getContentProvider();
            this.initState = true;
            String[] partsList = propertiesEditionProvider.partsList();
            this.initTabbedControl(propertiesEditionProvider, partsList);
            this.initState = false;
        }
    }

    protected void initTabbedControl(PropertiesEditionContentProvider propertiesEditionProvider, String[] partsList) {
        this.resetTab();
        ArrayList<String> selectedParts = new ArrayList<String>();
        if (this.kind == 1) {
            this.toolkit.adapt((Control)this.folder, true, true);
            this.toolkit.getColors().initializeSectionToolBarColors();
            this.folder.setSelectionBackground(new Color[]{this.toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START"), this.toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END")}, new int[]{50}, true);
            this.folder.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.folder.setSelectionForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        int i = 0;
        while (i < partsList.length) {
            String nextComponentKey = partsList[i];
            IPropertiesEditionPart part = propertiesEditionProvider.getPropertiesEditionPart(this.kind, nextComponentKey);
            if (this.selectPart(nextComponentKey, part)) {
                selectedParts.add(nextComponentKey);
                this.addPartTab(propertiesEditionProvider, part, nextComponentKey);
            } else {
                part.setVisible(false);
            }
            ++i;
        }
        if (this.dynamicTabHeader) {
            if (selectedParts.size() > 1) {
                this.folder.setTabHeight(-1);
            } else {
                this.folder.setTabHeight(0);
            }
        }
        this.folder.setSelection(0);
    }

    private void addPartTab(PropertiesEditionContentProvider propertiesEditionProvider, IPropertiesEditionPart part, String key) {
        Composite editComposite = null;
        if (part instanceof ISWTPropertiesEditionPart) {
            editComposite = ((ISWTPropertiesEditionPart)((Object)part)).createFigure((Composite)this.folder);
        }
        if (part instanceof IFormPropertiesEditionPart) {
            Assert.isNotNull((Object)this.toolkit, (String)EEFRuntimeUIMessages.PropertiesEditionViewer_widget_factory_not_defined);
            editComposite = ((IFormPropertiesEditionPart)((Object)part)).createFigure((Composite)this.folder, this.toolkit);
        }
        if (editComposite != null) {
            if (this.allResources == null && this.getEObjectFromInput() != null) {
                propertiesEditionProvider.initPart(propertiesEditionProvider.translatePart(key), this.kind, this.getEObjectFromInput());
            } else {
                propertiesEditionProvider.initPart(propertiesEditionProvider.translatePart(key), this.kind, this.getEObjectFromInput(), this.allResources);
            }
        } else {
            editComposite = new Composite((Composite)this.folder, 0);
        }
        CTabItem tab = new CTabItem(this.folder, 0);
        tab.setControl((Control)editComposite);
        tab.setText(part.getTitle());
    }

    private void resetTab() {
        if (this.folder.getItemCount() > 0) {
            CTabItem[] items = this.folder.getItems();
            int i = 0;
            while (i < items.length) {
                CTabItem cTabItem = items[i];
                if (!cTabItem.getControl().isDisposed()) {
                    cTabItem.getControl().dispose();
                }
                if (!cTabItem.isDisposed()) {
                    cTabItem.dispose();
                }
                ++i;
            }
        }
    }

    public void refreshTab() {
        this.getSelectedPart().refresh();
        PropertiesEditionContentProvider propertiesEditionContentProvider = (PropertiesEditionContentProvider)this.getContentProvider();
        propertiesEditionContentProvider.initPart(propertiesEditionContentProvider.translatePart(this.folder.getSelection().getText()), this.kind, this.getEObjectFromInput());
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    private void updateScrollSize() {
        if (this.folder.getSelection() != null && this.folder.getSelection().getControl() != null) {
            this.scroll.setMinSize(this.folder.getSelection().getControl().computeSize(-1, -1));
        }
    }

    private class ItemListener
    implements ControlListener {
        Control listenedControl = null;

        private ItemListener() {
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            PropertiesEditionViewer.this.updateScrollSize();
        }

        public void updateControlListener() {
            this.removeControlListener();
            Control control2 = PropertiesEditionViewer.this.folder.getSelection().getControl();
            if (control2 != null) {
                ((PropertiesEditionViewer)PropertiesEditionViewer.this).listener.listenedControl = control2;
                control2.addControlListener((ControlListener)PropertiesEditionViewer.this.listener);
            }
        }

        public void removeControlListener() {
            if (((PropertiesEditionViewer)PropertiesEditionViewer.this).listener.listenedControl != null && !((PropertiesEditionViewer)PropertiesEditionViewer.this).listener.listenedControl.isDisposed()) {
                ((PropertiesEditionViewer)PropertiesEditionViewer.this).listener.listenedControl.removeControlListener((ControlListener)PropertiesEditionViewer.this.listener);
            }
        }
    }
}

