/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class ManyExternalReferenceMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(ManyExternalReferenceMapper.class);

    public void processManyReference(PAnnotatedEReference paReference) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating many valued attribute mapping for " + paReference));
        }
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)paReference;
        Element collElement = this.addCollectionElement((PAnnotatedEStructuralFeature)paReference);
        Element keyElement = collElement.addElement("key");
        JoinTable jt = this.getJoinTable(paReference);
        ArrayList<JoinColumn> jcs = paReference.getJoinColumns() == null ? new ArrayList<JoinColumn>() : paReference.getJoinColumns();
        OneToMany otm = paReference.getOneToMany();
        if (jt != null) {
            this.addJoinTable(hbReference, collElement, keyElement, jt);
            this.addKeyColumns(hbReference, keyElement, jcs);
        } else {
            this.addKeyColumns(hbReference, keyElement, jcs);
        }
        if (otm.isIndexed() && hbReference.getHbIdBag() == null) {
            this.addListIndex(collElement, (PAnnotatedEStructuralFeature)paReference);
        }
        this.addFetchType(collElement, otm.getFetch());
        this.addCascadesForMany(collElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)otm.getCascade(), false));
        this.addElementElement(collElement, (PAnnotatedEStructuralFeature)paReference, this.getColumns((PAnnotatedEStructuralFeature)paReference), otm.getTargetEntity());
        this.addAccessor(collElement);
        this.mapFilter(collElement, (List<Filter>)hbReference.getFilter());
    }
}

