/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationFactory;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.FilterDef;
import org.eclipse.emf.teneo.hibernate.hbannotation.NamedQuery;
import org.eclipse.emf.teneo.hibernate.hbannotation.ParamDef;
import org.eclipse.emf.teneo.hibernate.hbannotation.Parameter;
import org.eclipse.emf.teneo.hibernate.hbannotation.TypeDef;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEClass;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEDataType;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEPackage;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.mapping.strategy.impl.ClassicEntityNameStrategy;
import org.eclipse.emf.teneo.simpledom.Document;
import org.eclipse.emf.teneo.simpledom.DocumentHelper;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMappingGenerator
implements ExtensionPoint,
ExtensionManagerAware {
    private static final Log log = LogFactory.getLog(HibernateMappingGenerator.class);
    private Set<PAnnotatedEClass> processedPAClasses = null;
    private MappingContext hbmContext;
    private ExtensionManager extensionManager;
    private PersistenceOptions persistenceOptions;

    protected void initEntityNames(MappingContext hbmContext, PAnnotatedModel paModel) {
        for (PAnnotatedEPackage pae : paModel.getPaEPackages()) {
            for (PAnnotatedEClass paClass : pae.getPaEClasses()) {
                if (paClass.getEntity() == null) continue;
                hbmContext.setEntityName(paClass.getModelEClass(), this.getEntityName(paClass));
            }
        }
    }

    protected String getEntityName(PAnnotatedEClass paClass) {
        EClass eclass = paClass.getModelEClass();
        String name = paClass.getEntity().getName();
        if (name == null) {
            name = this.hbmContext.getEntityNameStrategy().toEntityName(eclass);
        }
        return name;
    }

    public Document generate(PAnnotatedModel paModel) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Geneting Hibernate mapping for " + paModel));
        }
        try {
            this.hbmContext = (MappingContext)((Object)this.getExtensionManager().getExtension(MappingContext.class));
            this.hbmContext.setMappingProperties(this.getPersistenceOptions());
            this.hbmContext.setPaModel(paModel);
            this.hbmContext.beginDocument(this.createDocument());
            this.initEntityNames(this.hbmContext, paModel);
            this.processTypedefs(paModel);
            this.processPersistentClasses(paModel);
            for (PAnnotatedEPackage paPackage : paModel.getPaEPackages()) {
                this.processPANamedQueries(paPackage);
                for (PAnnotatedEClass paEClass : paPackage.getPaEClasses()) {
                    this.processPANamedQueries(paEClass);
                }
            }
            return this.hbmContext.endDocument();
        }
        catch (MappingException exc) {
            throw new MappingException("Hibernate mapping generation failed", (Exception)((Object)exc));
        }
    }

    public String generateToString(PAnnotatedModel annotatedModel) throws MappingException {
        return this.generate(annotatedModel).emitXML();
    }

    protected Document createDocument() {
        Document mappingDoc = new Document();
        mappingDoc.setDocType("<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">");
        mappingDoc.setRoot(DocumentHelper.createElement((String)"hibernate-mapping"));
        if (!(this.hbmContext.getEntityNameStrategy() instanceof ClassicEntityNameStrategy)) {
            log.debug((Object)"Setting auto-import=false because eclassnamingstrategy is not the defaulteclassnamestrategy");
            mappingDoc.getRoot().addAttribute("auto-import", "false");
        }
        return mappingDoc;
    }

    protected void processPersistentClasses(PAnnotatedModel paModel) {
        try {
            this.processedPAClasses = new HashSet<PAnnotatedEClass>();
            for (PAnnotatedEPackage paPackage : paModel.getPaEPackages()) {
                for (PAnnotatedEClass paEClass : paPackage.getPaEClasses()) {
                    if (!this.hbmContext.isMapEMapAsTrueMap() || !StoreUtil.isMapEntry((EClass)paEClass.getModelEClass())) {
                        this.processPAClass(paEClass);
                    }
                    this.mapFilterDef(this.hbmContext.getCurrent(), (List<FilterDef>)((HbAnnotatedEClass)paEClass).getFilterDef());
                }
                this.mapFilterDef(this.hbmContext.getCurrent(), (List<FilterDef>)((HbAnnotatedEPackage)paPackage).getFilterDef());
            }
        }
        finally {
            this.processedPAClasses = null;
        }
    }

    protected void mapFilterDef(Element parentElement, List<FilterDef> filterDefs) {
        for (FilterDef fd : filterDefs) {
            Element fdElement = parentElement.addElement("filter-def");
            fdElement.addAttribute("name", fd.getName());
            if (fd.getDefaultCondition() != null) {
                fdElement.addAttribute("condition", fd.getDefaultCondition());
            }
            for (ParamDef pd : fd.getParameters()) {
                Element pdElement = fdElement.addElement("filter-param");
                pdElement.addAttribute("name", pd.getName());
                pdElement.addAttribute("type", pd.getType());
            }
        }
    }

    protected void processPAClass(PAnnotatedEClass paEClass) {
        if (this.processedPAClasses.add(paEClass)) {
            if (paEClass.getEntity() != null && paEClass.getMappedSuperclass() == null) {
                PAnnotatedEClass paSuperEntity = paEClass.getPaSuperEntity();
                if (paSuperEntity != null) {
                    this.processPAClass(paSuperEntity);
                }
                if (paEClass.getModelEClass().getInstanceClass() == Map.Entry.class && paEClass.getEntity() == null) {
                    log.debug((Object)("Ignoring " + paEClass.getModelEClass().getName() + " ignored, is a map entry"));
                    paEClass.setTransient(PannotationFactory.eINSTANCE.createTransient());
                    return;
                }
                if (paEClass.getExternal() != null) {
                    return;
                }
                if (((HbAnnotatedEClass)paEClass).getHbType() != null) {
                    return;
                }
                this.hbmContext.setCurrentEClass(paEClass.getModelEClass());
                this.hbmContext.getEntityMapper().processEntity(paEClass);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping non-persistent class " + paEClass));
            }
        }
    }

    protected void processTypedefs(PAnnotatedModel paModel) {
        for (PAnnotatedEPackage annotatedEPackage : paModel.getPaEPackages()) {
            HbAnnotatedEPackage paPackage = (HbAnnotatedEPackage)annotatedEPackage;
            for (TypeDef td : paPackage.getHbTypeDef()) {
                this.emitTypeDef(td);
            }
            for (PAnnotatedEDataType annotatedEDataType : paPackage.getPaEDataTypes()) {
                HbAnnotatedEDataType hed = (HbAnnotatedEDataType)annotatedEDataType;
                if (hed.getHbTypeDef() == null) continue;
                this.emitTypeDef(hed.getHbTypeDef());
            }
        }
    }

    protected void processPANamedQueries(PAnnotatedEClass paEClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing Queries for " + paEClass.getModelEClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"********************** Named Queries ***************************");
            for (NamedQuery namedQuery : ((HbAnnotatedEClass)paEClass).getHbNamedQuery()) {
                log.info((Object)(String.valueOf(namedQuery.getName()) + ":" + namedQuery.getQuery()));
            }
            log.debug((Object)"****************************************************************");
        }
        for (NamedQuery namedQuery : ((HbAnnotatedEClass)paEClass).getHbNamedQuery()) {
            Element target = this.hbmContext.getCurrent().addElement("query");
            target.addAttribute("name", namedQuery.getName());
            target.addText("<![CDATA[" + namedQuery.getQuery() + "]]>");
        }
    }

    protected void processPANamedQueries(PAnnotatedEPackage paEPackage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing Queries for " + paEPackage.getModelEPackage().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"********************** Named Queries ***************************");
            for (NamedQuery namedQuery : ((HbAnnotatedEPackage)paEPackage).getHbNamedQuery()) {
                log.info((Object)(String.valueOf(namedQuery.getName()) + ":" + namedQuery.getQuery()));
            }
            log.debug((Object)"****************************************************************");
        }
        for (NamedQuery namedQuery : ((HbAnnotatedEPackage)paEPackage).getHbNamedQuery()) {
            Element target = this.hbmContext.getCurrent().addElement("query");
            target.addAttribute("name", namedQuery.getName());
            target.addText("<![CDATA[" + namedQuery.getQuery() + "]]>");
        }
    }

    protected void emitTypeDef(TypeDef td) {
        Element target = this.hbmContext.getCurrent().addElement("typedef");
        target.addAttribute("name", td.getName());
        target.addAttribute("class", td.getTypeClass());
        for (Parameter param : td.getParameters()) {
            target.addElement("param").addAttribute("name", param.getName()).addText(param.getValue());
        }
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public PersistenceOptions getPersistenceOptions() {
        return this.persistenceOptions;
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        this.persistenceOptions = persistenceOptions;
    }
}

