/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.hbannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HbFetchType implements Enumerator
{
    JOIN(0, "JOIN", "JOIN"),
    SELECT(1, "SELECT", "SELECT"),
    SUBSELECT(2, "SUBSELECT", "SUBSELECT");

    public static final int JOIN_VALUE = 0;
    public static final int SELECT_VALUE = 1;
    public static final int SUBSELECT_VALUE = 2;
    private static final HbFetchType[] VALUES_ARRAY;
    public static final List<HbFetchType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HbFetchType[]{JOIN, SELECT, SUBSELECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HbFetchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HbFetchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HbFetchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HbFetchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HbFetchType get(int value) {
        switch (value) {
            case 0: {
                return JOIN;
            }
            case 1: {
                return SELECT;
            }
            case 2: {
                return SUBSELECT;
            }
        }
        return null;
    }

    private HbFetchType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

