/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.hook;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.ide.hook.IResourceSetHook;
import org.eclipse.emf.compare.ide.internal.hook.ResourceSetHookDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSetHookRegistry {
    private static final Function<ResourceSetHookDescriptor, IResourceSetHook> TO_HOOK = new Function<ResourceSetHookDescriptor, IResourceSetHook>(){

        public IResourceSetHook apply(ResourceSetHookDescriptor input) {
            return input.getHook();
        }
    };
    private final Map<String, ResourceSetHookDescriptor> registry = new ConcurrentHashMap<String, ResourceSetHookDescriptor>();

    public Collection<IResourceSetHook> getResourceSetHooks() {
        return Collections.unmodifiableCollection(Collections2.filter((Collection)Collections2.transform(this.registry.values(), TO_HOOK), (Predicate)Predicates.notNull()));
    }

    void add(String id, ResourceSetHookDescriptor resourceSetHookDescriptor) {
        this.registry.put(id, resourceSetHookDescriptor);
    }

    boolean remove(String id) {
        return this.registry.remove(id) != null;
    }
}

