/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AdditiveMergeCriterion;
import org.eclipse.emf.compare.merge.ConflictMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.ecore.EObject;

public class AdditiveConflictMerger
extends ConflictMerger {
    public AdditiveConflictMerger() {
        this.mergeOptions.put("merge.criterion", AdditiveMergeCriterion.INSTANCE);
    }

    public boolean apply(IMergeCriterion criterion) {
        return criterion == AdditiveMergeCriterion.INSTANCE;
    }

    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        Comparison comparison = target.getMatch().getComparison();
        EList<Diff> rightDifferences = target.getConflict().getRightDifferences();
        for (Diff diff : rightDifferences) {
            EList<Diff> differences = diff.getMatch().getDifferences();
            for (Diff diff2 : differences) {
                if (!this.isEquivalentFromDifferentSides(comparison, diff, diff2)) continue;
                diff.setState(DifferenceState.MERGED);
                diff2.setState(DifferenceState.MERGED);
            }
        }
        if (target.getSource() == DifferenceSource.RIGHT) {
            for (Diff diff : target.getRefines()) {
                this.getMergerDelegate(diff).copyRightToLeft(diff, monitor);
            }
        }
        if (target.getState() == DifferenceState.MERGED) {
            return;
        }
        if (target.getSource() == DifferenceSource.RIGHT && target.getKind() != DifferenceKind.DELETE) {
            super.copyRightToLeft(target, monitor);
        } else if (target.getSource() == DifferenceSource.LEFT && target.getKind() == DifferenceKind.DELETE) {
            super.copyRightToLeft(target, monitor);
        } else {
            target.setState(DifferenceState.MERGED);
            for (Diff refiningDiff : target.getRefinedBy()) {
                refiningDiff.setState(DifferenceState.MERGED);
            }
        }
    }

    private boolean isEquivalentFromDifferentSides(Comparison comparison, Diff diff, Diff diff2) {
        if (diff.eClass() == diff2.eClass() && diff.getSource() != diff2.getSource() && diff.getKind() == diff2.getKind()) {
            if (diff instanceof ReferenceChange) {
                EObject value = ((ReferenceChange)diff).getValue();
                EObject value2 = ((ReferenceChange)diff2).getValue();
                if (value == null && value2 == null) {
                    return true;
                }
                if (comparison.getMatch(value) == comparison.getMatch(value2)) {
                    return true;
                }
            } else if (diff instanceof AttributeChange && ((AttributeChange)diff).getValue() == ((AttributeChange)diff2).getValue()) {
                return true;
            }
        }
        return false;
    }
}

