/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.provider;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet.PapyrusFacetContentProviderWrapperAdapterFactory;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.item.MergeViewerItemConverter;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.TreeContentMergeViewerItemContentProvider;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.gmf.runtime.notation.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusTreeContentMergeViewerItemContentProvider
extends TreeContentMergeViewerItemContentProvider {
    private static final Predicate<Object> DIAGRAM_FILTER = new Predicate<Object>(){

        public boolean apply(Object input) {
            if (input instanceof IMergeViewerItem) {
                IMergeViewerItem item = (IMergeViewerItem)input;
                return PapyrusTreeContentMergeViewerItemContentProvider.containsNoDiagrams(PapyrusTreeContentMergeViewerItemContentProvider.asSet(new Object[]{item.getLeft(), item.getRight(), item.getAncestor()}));
            }
            if (input instanceof Match) {
                Match match = (Match)input;
                return PapyrusTreeContentMergeViewerItemContentProvider.containsNoDiagrams(PapyrusTreeContentMergeViewerItemContentProvider.asSet(new Object[]{match.getLeft(), match.getRight(), match.getOrigin()}));
            }
            return input instanceof Diagram;
        }
    };
    private EMFCompareConfiguration compareConfiguration;
    private MergeViewerItemConverter converter;
    private AdapterFactory itemAdapterFactory;

    public PapyrusTreeContentMergeViewerItemContentProvider(AdapterFactory adapterFactory, EMFCompareConfiguration compareConfiguration, IDifferenceGroupProvider groupProvider, Predicate<? super EObject> predicate) {
        super(adapterFactory, groupProvider, predicate);
        this.adapterFactory = adapterFactory;
        this.compareConfiguration = compareConfiguration;
        this.itemAdapterFactory = new PapyrusFacetContentProviderWrapperAdapterFactory();
        this.converter = new MergeViewerItemConverter((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{this.itemAdapterFactory, adapterFactory}), compareConfiguration.getComparison());
    }

    public Object[] getElements(Object object) {
        if (object instanceof ICompareAccessor) {
            ICompareAccessor accessor = (ICompareAccessor)object;
            return Iterables.toArray(this.convert(this.filtered((Iterable<? extends IMergeViewerItem>)accessor.getItems())), Object.class);
        }
        return super.getElements(object);
    }

    public Object[] getChildren(Object object) {
        return Iterables.toArray((Iterable)Iterables.filter(Arrays.asList(super.getChildren(object)), DIAGRAM_FILTER), Object.class);
    }

    private Iterable<? extends IMergeViewerItem> convert(Iterable<? extends IMergeViewerItem> items) {
        return Iterables.transform(items, (Function)new Function<IMergeViewerItem, IMergeViewerItem>(){

            public IMergeViewerItem apply(IMergeViewerItem input) {
                return PapyrusTreeContentMergeViewerItemContentProvider.this.converter.convert(input);
            }
        });
    }

    private Iterable<? extends IMergeViewerItem> filtered(Iterable<? extends IMergeViewerItem> items) {
        StructureMergeViewerGrouper grouper = this.compareConfiguration.getStructureMergeViewerGrouper();
        StructureMergeViewerFilter filter = this.compareConfiguration.getStructureMergeViewerFilter();
        final IDifferenceGroupProvider provider = grouper.getProvider();
        final Predicate aggregatedPredicate = filter.getAggregatedPredicate();
        return Iterables.filter(items, (Predicate)new Predicate<IMergeViewerItem>(){

            public boolean apply(IMergeViewerItem item) {
                Match match = PapyrusTreeContentMergeViewerItemContentProvider.this.getMatch(item.getLeft(), item.getRight(), item.getAncestor());
                if (match == null) {
                    return true;
                }
                if (!DIAGRAM_FILTER.apply((Object)match)) {
                    return false;
                }
                return Iterables.any((Iterable)match.getAllDifferences(), (Predicate)new Predicate<Diff>(){

                    public boolean apply(Diff diff) {
                        return MergeViewerUtil.isVisibleInMergeViewer((Diff)diff, (IDifferenceGroupProvider)provider, (Predicate)aggregatedPredicate);
                    }
                });
            }
        });
    }

    private Match getMatch(Object left, Object right, Object origin) {
        Match match = this.getMatch(left);
        if (match != null) {
            return match;
        }
        match = this.getMatch(right);
        if (match != null) {
            return match;
        }
        return this.getMatch(origin);
    }

    private Match getMatch(Object object) {
        if (object == null) {
            return null;
        }
        for (Match match : this.compareConfiguration.getComparison().getMatches()) {
            if (object != match.getLeft() && object != match.getRight() && object != match.getOrigin()) continue;
            return match;
        }
        return null;
    }

    private static Set<Object> asSet(Object ... objects) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                builder.add(object);
            }
            ++n2;
        }
        return builder.build();
    }

    private static boolean containsNoDiagrams(Set<Object> objects) {
        return !Iterables.any(objects, (Predicate)Predicates.instanceOf(Diagram.class));
    }

    public void dispose() {
        if (IDisposable.class.isInstance(this.itemAdapterFactory)) {
            ((IDisposable)IDisposable.class.cast(this.itemAdapterFactory)).dispose();
        }
    }
}

