/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.util.concurrent.FutureCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.AbstractResourceResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteResolveComputation
extends AbstractResourceResolver
implements IComputation<URI> {
    private final FutureCallback<Object> postTreatment;

    public RemoteResolveComputation(ResourceComputationScheduler<URI> scheduler, DiagnosticSupport diagnostic, SynchronizedResourceSet resourceSet, URI uri, FutureCallback<Object> postTreatment, ThreadSafeProgressMonitor monitor) {
        super(scheduler, diagnostic, resourceSet, uri, monitor);
        this.postTreatment = postTreatment;
    }

    @Override
    public void run() {
        if (ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)this.tspm)) {
            this.scheduler.demandShutdown();
            return;
        }
        Resource resource = this.resourceSet.loadResource(this.uri);
        Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
        if (resourceDiagnostic.getSeverity() >= 2) {
            this.diagnostic.merge(resourceDiagnostic);
        }
        this.demandUnload(resource);
    }

    @Override
    public URI getKey() {
        return this.uri;
    }

    @Override
    public FutureCallback<Object> getPostTreatment() {
        return this.postTreatment;
    }
}

