/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyData {
    private final IEMFCompareConfiguration compareConfiguration;
    private Set<Diff> requires;
    private Set<Diff> unmergeables;
    private final WrappableTreeViewer treeViewer;
    private Multimap<Diff, TreeItem> diffToItemsMappings;
    private static final Function<Object, EObject> ADAPTER__TARGET__DATA = new Function<Object, EObject>(){

        public EObject apply(Object object) {
            return EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(object);
        }
    };

    public DependencyData(IEMFCompareConfiguration compareConfiguration, WrappableTreeViewer treeViewer) {
        this.compareConfiguration = compareConfiguration;
        this.treeViewer = treeViewer;
        this.requires = Sets.newHashSet();
        this.unmergeables = Sets.newHashSet();
        this.diffToItemsMappings = HashMultimap.create();
    }

    public void updateDependencies(ISelection selection, IMerger.Registry mergerRegistry) {
        boolean leftEditable = this.compareConfiguration.isLeftEditable();
        boolean rightEditable = this.compareConfiguration.isRightEditable();
        if (leftEditable || rightEditable) {
            Iterable selectedDiffs = Iterables.filter(DependencyData.getSelectedComparisonObjects(selection), Diff.class);
            MergeMode mergePreviewMode = this.compareConfiguration.getMergePreviewMode();
            this.requires = Sets.newHashSet();
            this.unmergeables = Sets.newHashSet();
            for (Diff diff : selectedDiffs) {
                boolean leftToRight = mergePreviewMode.isLeftToRight(diff, leftEditable, rightEditable);
                IMerger diffMerger = mergerRegistry.getHighestRankingMerger(diff);
                if (!(diffMerger instanceof IMerger2)) continue;
                Iterables.addAll(this.requires, (Iterable)((IMerger2)diffMerger).getResultingMerges(diff, leftToRight, Collections.emptySet()));
                this.requires.remove(diff);
                Iterables.addAll(this.unmergeables, (Iterable)((IMerger2)diffMerger).getResultingRejections(diff, leftToRight, Collections.emptySet()));
                this.unmergeables.remove(diff);
            }
        }
    }

    public void updateTreeItemMappings() {
        this.diffToItemsMappings = HashMultimap.create();
        Tree tree = this.treeViewer.getTree();
        TreeItem[] children = tree.getItems();
        if (children.length == 1 && children[0].getData() == null) {
            this.treeViewer.createChildren((Widget)tree);
        }
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.associateTreeItem(item);
            ++n2;
        }
    }

    private void associateTreeItem(TreeItem item) {
        TreeItem[] children;
        Object itemData = item.getData();
        EObject eObject = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(itemData);
        if (eObject instanceof Diff) {
            this.diffToItemsMappings.put((Object)((Diff)eObject), (Object)item);
        }
        if ((children = item.getItems()).length > 0 && children[0].getData() == null) {
            this.treeViewer.createChildren((Widget)item);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.associateTreeItem(child);
            ++n2;
        }
    }

    private static List<EObject> getSelectedComparisonObjects(ISelection selection) {
        ArrayList ret = Lists.newArrayList();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            Iterable data = Iterables.transform((Iterable)selectedObjects, ADAPTER__TARGET__DATA);
            Iterable notNullData = Iterables.filter((Iterable)data, (Predicate)Predicates.notNull());
            Iterables.addAll((Collection)ret, (Iterable)notNullData);
        }
        return ret;
    }

    public Set<Diff> getRequires() {
        return this.requires;
    }

    public Set<Diff> getUnmergeables() {
        return this.unmergeables;
    }

    public Collection<TreeItem> getTreeItems(Diff diff) {
        return this.diffToItemsMappings.get((Object)diff);
    }
}

