/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractMetamodelCollector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredMetamodelCollector
extends AbstractMetamodelCollector {
    @Override
    public void addPropoposals(final Collection<ICompletionProposal> proposals, final QvtCompletionData data) {
        if (this.isInitialized(data)) {
            this.retrieveMetamodels(proposals, data, null);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IProgressService progressService = workbench.getProgressService();
            try {
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        RegisteredMetamodelCollector.this.retrieveMetamodels(proposals, data, monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
        }
    }

    private boolean isInitialized(QvtCompletionData data) {
        String[] metamodelIds;
        MetamodelRegistry metamodelRegistry = data.getMetamodelRegistry();
        String[] stringArray = metamodelIds = metamodelRegistry.getMetamodelIds();
        int n = metamodelIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                IMetamodelDesc metamodelDesc = metamodelRegistry.getMetamodelDesc(id);
                if (!metamodelDesc.isLoaded()) {
                    return false;
                }
            }
            catch (EmfException e) {
                Activator.log(e);
            }
            ++n2;
        }
        return true;
    }

    private void retrieveMetamodels(Collection<ICompletionProposal> proposals, QvtCompletionData data, IProgressMonitor monitor) {
        MetamodelRegistry metamodelRegistry = data.getMetamodelRegistry();
        String[] metamodelIds = metamodelRegistry.getMetamodelIds();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.RegisteredMetamodelCollector_RetrievingMetamodelsTaskName, metamodelIds.length);
        ArrayList<String> rootPackages = new ArrayList<String>();
        List<Object> activeMetamodelURIs = Arrays.asList(data.getEnvironment().getEPackageRegistry().keySet().toArray());
        String[] stringArray = metamodelIds;
        int n = metamodelIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                IMetamodelDesc metamodelDesc = metamodelRegistry.getMetamodelDesc(id);
                monitor.worked(1);
                EPackage pack = EmfUtil.getRootPackage((EPackage)metamodelDesc.getModel());
                if (!rootPackages.contains(pack) && !activeMetamodelURIs.contains(pack.getNsURI())) {
                    String proposalString = RegisteredMetamodelCollector.getProposalString(data, pack);
                    rootPackages.add(proposalString);
                }
            }
            catch (EmfException e) {
                Activator.log(e);
            }
            ++n2;
        }
        Collections.sort(rootPackages);
        for (String proposalString : rootPackages) {
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(proposalString, "cat-package", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
        monitor.done();
    }
}

