/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.util;

import java.util.ArrayList;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;

public class StringLineNumberProvider
implements LineNumberProvider {
    private final ArrayList<Integer> myLineEnds = new ArrayList();

    public StringLineNumberProvider(String s) {
        this.parseString(s);
    }

    public int getLineEnd(int lineNumber) {
        return this.getLineEndInt(lineNumber - 1);
    }

    public int getLineCount() {
        return this.myLineEnds.size();
    }

    public int getLineNumber(int offset) {
        if (offset < 0) {
            return -1;
        }
        return this.getLineNumberInt(offset) + 1;
    }

    private int getLineEndInt(int lineNumber) {
        return this.myLineEnds.get(lineNumber);
    }

    public int getLineNumberInt(int offset) {
        int a = 0;
        if (this.getLineEndInt(a) >= offset) {
            return a;
        }
        int b = this.myLineEnds.size() - 1;
        if (this.getLineEndInt(b) < offset) {
            return b;
        }
        int result = b;
        while (a <= b) {
            int c = (a + b) / 2;
            int cValue = this.getLineEndInt(c);
            if (cValue > offset) {
                result = c;
                b = c - 1;
                continue;
            }
            if (cValue < offset) {
                a = c + 1;
                continue;
            }
            return c;
        }
        return result;
    }

    private void parseString(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                this.myLineEnds.add(new Integer(i));
            }
            if (s.charAt(i) == '\r' && i < s.length() - 1 && s.charAt(i + 1) != '\n') {
                this.myLineEnds.add(new Integer(i));
            }
            ++i;
        }
        if (s.length() != 0 && (this.myLineEnds.isEmpty() || this.getLineEndInt(this.getLineCount() - 1) != s.length() - 1)) {
            this.myLineEnds.add(new Integer(s.length() - 1));
        }
    }
}

