/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.wizard.atlproject;

import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class AtlProjectCreator
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected WizardNewProjectCreationPage page;
    protected IConfigurationElement configElement;

    public AtlProjectCreator() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("AtlProjectCreator.Title"));
    }

    public void addPages() {
        this.page = new WizardNewProjectCreationPage(Messages.getString("AtlProjectCreator.Page.Name"));
        this.page.setTitle(Messages.getString("AtlProjectCreator.Title"));
        this.page.setDescription(Messages.getString("AtlProjectCreator.Page.Description"));
        this.page.setImageDescriptor(AtlUIPlugin.getImageDescriptor("ATLWizard.png"));
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(AtlProjectCreator.this.page.getProjectName());
                IPath location = AtlProjectCreator.this.page.getLocationPath();
                if (!project.exists()) {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(AtlProjectCreator.this.page.getProjectName());
                    if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                        location = null;
                    }
                    desc.setLocation(location);
                    project.create(desc, monitor);
                    project.open(monitor);
                }
                if (!project.isOpen()) {
                    project.open(monitor);
                }
                AtlProjectCreator.this.addNature(project, "org.eclipse.m2m.atl.adt.builder.atlNature");
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 0, e.getMessage(), (Throwable)e);
            AtlUIPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addNature(IProject project, String natureId) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

