/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.AtlParser;
import org.eclipse.m2m.atl.engine.AtlStandaloneCompiler;
import org.eclipse.m2m.atl.engine.CompileTimeError;
import org.eclipse.m2m.atl.engine.ProblemConverter;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public abstract class AtlDefaultCompiler
implements AtlStandaloneCompiler {
    private AtlModelHandler amh = AtlModelHandler.getDefault("EMF");
    private ASMModel pbmm = this.amh.getBuiltInMetaModel("Problem");

    public final CompileTimeError[] compile(InputStream in, String outputFileName) {
        EObject[] eObjects = this.internalCompile(in, outputFileName);
        CompileTimeError[] result = new CompileTimeError[eObjects.length];
        int i = 0;
        while (i < eObjects.length) {
            result[i] = ProblemConverter.convertProblem(eObjects[i]);
            ++i;
        }
        return result;
    }

    public EObject[] compileWithProblemModel(InputStream in, String outputFileName) {
        return this.internalCompile(in, outputFileName);
    }

    protected abstract URL getSemanticAnalyzerURL();

    protected abstract URL getCodegeneratorURL();

    private Object[] getProblems(ASMModel problems, EObject[] prev) {
        Object[] ret = new Object[2];
        EObject[] pbsa = null;
        Set pbs = problems.getElementsByType("Problem");
        int nbErrors = 0;
        if (pbs != null) {
            pbsa = new EObject[pbs.size() + prev.length];
            System.arraycopy(prev, 0, pbsa, 0, prev.length);
            int k = prev.length;
            for (ASMEMFModelElement ame : pbs) {
                pbsa[k++] = ame.getObject();
                if (!"error".equals(((ASMEnumLiteral)ame.get(null, "severity")).getName())) continue;
                ++nbErrors;
            }
        }
        ret[0] = new Integer(nbErrors);
        ret[1] = pbsa;
        return ret;
    }

    private EObject[] internalCompile(InputStream in, String outputFileName) {
        EObject[] ret = null;
        ASMModel[] parsed = AtlParser.getDefault().parseToModelWithProblems(in);
        ASMModel atlmodel = parsed[0];
        ASMModel problems = parsed[1];
        Object[] a = this.getProblems(problems, new EObject[0]);
        int nbErrors = (Integer)a[0];
        ret = (EObject[])a[1];
        if (nbErrors == 0) {
            HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
            models.put("MOF", this.amh.getMof());
            models.put("ATL", atlmodel.getMetamodel());
            models.put("IN", atlmodel);
            models.put("Problem", this.pbmm);
            models.put("OUT", problems);
            Map params = Collections.EMPTY_MAP;
            Map libs = Collections.EMPTY_MAP;
            AtlLauncher.getDefault().launch(this.getSemanticAnalyzerURL(), libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            a = this.getProblems(problems, ret);
            nbErrors = (Integer)a[0];
            ret = (EObject[])a[1];
        }
        if (nbErrors == 0) {
            AtlModelHandler amh = AtlModelHandler.getDefault("EMF");
            HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
            models.put("MOF", amh.getMof());
            models.put("ATL", amh.getAtl());
            models.put("IN", atlmodel);
            models.put("Problem", this.pbmm);
            models.put("OUT", problems);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("debug", "false");
            params.put("WriteTo", outputFileName);
            HashMap<String, URL> libs = new HashMap<String, URL>();
            libs.put("typeencoding", AtlParser.class.getResource("resources/typeencoding.asm"));
            libs.put("strings", AtlParser.class.getResource("resources/strings.asm"));
            AtlLauncher.getDefault().launch(this.getCodegeneratorURL(), libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            a = this.getProblems(problems, ret);
            nbErrors = (Integer)a[0];
            ret = (EObject[])a[1];
        }
        return ret;
    }
}

