/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.scope;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@Dependent
public class DependantBeans {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final int id;
    private List<Integer> list = new CopyOnWriteArrayList<Integer>();
    private static final List<String> INSTANCES = new CopyOnWriteArrayList<String>();

    public DependantBeans() {
        INSTANCES.add(this.toString());
        this.id = COUNTER.getAndIncrement();
    }

    static List<String> getInstances() {
        return INSTANCES;
    }

    @Outgoing(value="source")
    public Publisher<Integer> source() {
        return ReactiveStreams.of((Object)this.id).buildRs();
    }

    @Incoming(value="source")
    @Outgoing(value="output")
    public int process(int i) {
        return i + 1;
    }

    @Incoming(value="output")
    public void sink(int v) {
        this.list.add(v);
    }

    public List<Integer> getList() {
        return this.list;
    }
}

