/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.MeteredClassBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeteredClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "MeteredClassBean";
    private static final String CONSTRUCTOR_METER_NAME = MetricsUtil.absoluteMetricName(MeteredClassBean.class, "meteredClass", "MeteredClassBean");
    private static MetricID constructorMID;
    private static final String[] METHOD_NAMES;
    private static final Set<String> METHOD_METER_NAMES;
    private static final MetricFilter METHOD_METERS;
    private static final Set<String> METER_NAMES;
    private static Set<MetricID> meterMIDs;
    private static final AtomicLong METHOD_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private MeteredClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{MeteredClassBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        constructorMID = new MetricID(CONSTRUCTOR_METER_NAME);
        meterMIDs = MetricsUtil.createMetricIDs(METER_NAMES);
    }

    @Test
    @InSequence(value=1)
    public void meteredMethodsNotCalledYet() {
        Assert.assertThat((String)"Meters are not registered correctly", this.registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(meterMIDs)));
        Assert.assertThat((String)"Method meter counts are incorrect", this.registry.getMeters(METHOD_METERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.get()))));
    }

    @Test
    @InSequence(value=2)
    public void callMeteredMethodsOnce() {
        Assert.assertThat((String)"Meters are not registered correctly", this.registry.getMeters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(meterMIDs)));
        this.bean.meteredMethodOne();
        this.bean.meteredMethodTwo();
        this.bean.meteredMethodProtected();
        this.bean.meteredMethodPackagedPrivate();
        Assert.assertThat((String)"Method meter counts are incorrect", this.registry.getMeters(METHOD_METERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.incrementAndGet()))));
        Assert.assertThat((String)"Constructor's metric should be incremented at least once", (Object)this.registry.getMeter(constructorMID).getCount(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L))));
    }

    static {
        METHOD_NAMES = new String[]{"meteredMethodOne", "meteredMethodTwo", "meteredMethodProtected", "meteredMethodPackagedPrivate"};
        METHOD_METER_NAMES = MetricsUtil.absoluteMetricNames(MeteredClassBean.class, "meteredClass", METHOD_NAMES);
        METHOD_METERS = new MetricFilter(){

            public boolean matches(MetricID metricID, Metric metric) {
                return METHOD_METER_NAMES.contains(metricID.getName());
            }
        };
        METER_NAMES = MetricsUtil.absoluteMetricNames(MeteredClassBean.class, "meteredClass", METHOD_NAMES, new String[]{CONSTRUCTOR_NAME});
        METHOD_COUNT = new AtomicLong();
    }
}

