/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs.jwe;

import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RolesAllowedSignEncryptTest
extends Arquillian {
    private static String token;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = RolesAllowedSignEncryptTest.class.getResource("/META-INF/microprofile-config-verify-decrypt.properties");
        URL verifyKey = RolesAllowedSignEncryptTest.class.getResource("/publicKey4k.pem");
        URL decryptKey = RolesAllowedSignEncryptTest.class.getResource("/privateKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"RolesAllowedSignEncryptTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_2.name()), "MPJWTTESTVERSION")).addAsResource(decryptKey, "/privateKey.pem")).addAsResource(verifyKey, "/publicKey4k.pem")).addClass(RolesEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        token = RolesAllowedSignEncryptTest.signEncryptClaims("/Token1.json");
    }

    private static String signEncryptClaims(String jsonResName) throws Exception {
        return RolesAllowedSignEncryptTest.signEncryptClaimsWithOptionalCty(jsonResName, true);
    }

    private static String signEncryptClaimsWithOptionalCty(String jsonResName, boolean cty) throws Exception {
        RSAPrivateKey signingKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        RSAPublicKey encryptionKey = TokenUtils.readPublicKey((String)"/publicKey.pem");
        return TokenUtils.signEncryptClaims((PrivateKey)signingKey, null, (PublicKey)encryptionKey, null, (String)jsonResName, (boolean)cty);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with no token fails with HTTP_UNAUTHORIZED")
    public void callEchoNoAuth() {
        Reporter.log((String)"callEchoNoAuth, expect HTTP_UNAUTHORIZED");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Attempting access with BASIC auth header should fail with HTTP_UNAUTHORIZED")
    public void callEchoBASIC() {
        Reporter.log((String)"callEchoBASIC, expect HTTP_UNAUTHORIZED");
        byte[] tokenb = Base64.getEncoder().encode("jdoe@example.com:password".getBytes());
        String token = new String(tokenb);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("BASIC " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT succeeds with HTTP_OK, and replies with hello, user={token upn claim}")
    public void callEcho() {
        Reporter.log((String)"callEcho, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"hello, user=jdoe@example.com");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT fail with HTTP_UNAUTHORIZED if no 'cty' header is set")
    public void callEchoWithoutCty() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_OK");
        String token2 = RolesAllowedSignEncryptTest.signEncryptClaimsWithOptionalCty("/Token1.json", false);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT which fails with HTTP_UNAUTHORIZED when token is signed")
    public void callEchoSignToken() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_UNAUTHORIZED");
        RSAPrivateKey signingKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String signToken = TokenUtils.signClaims((PrivateKey)signingKey, (String)"/Token1.json", (String)"/Token1.json", null, null);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + signToken)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT which fails with HTTP_UNAUTHORIZED when token is encrypted")
    public void callEchoSignEncryptToken() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_UNAUTHORIZED");
        String encryptToken = TokenUtils.encryptClaims((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + encryptToken)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT but no associated role fails with HTTP_FORBIDDEN")
    public void callEcho2() {
        Reporter.log((String)"callEcho2, expect HTTP_FORBIDDEN");
        String uri = this.baseURL.toExternalForm() + "endp/echo2";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)403);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT is able to access checkIsUserInRole with HTTP_OK")
    public void checkIsUserInRole() {
        Reporter.log((String)"checkIsUserInRole, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/checkIsUserInRole";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT Token2 fails to access checkIsUserInRole with HTTP_FORBIDDEN")
    public void checkIsUserInRoleToken2() throws Exception {
        Reporter.log((String)"checkIsUserInRoleToken2, expect HTTP_FORBIDDEN");
        String token2 = RolesAllowedSignEncryptTest.signEncryptClaims("/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/checkIsUserInRole";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)403);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT Token2 is able to access echoNeedsToken2Role with HTTP_OK")
    public void echoNeedsToken2Role() throws Exception {
        Reporter.log((String)"echoNeedsToken2Role, expect HTTP_OK");
        String token2 = RolesAllowedSignEncryptTest.signEncryptClaims("/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/echoNeedsToken2Role";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT Token2 calling echo fails with HTTP_FORBIDDEN")
    public void echoWithToken2() throws Exception {
        Reporter.log((String)"echoWithToken2, expect HTTP_FORBIDDEN");
        String token2 = RolesAllowedSignEncryptTest.signEncryptClaims("/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)403);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT SecurityContext.getUserPrincipal() is a JsonWebToken")
    public void getPrincipalClass() {
        Reporter.log((String)"getPrincipalClass, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/getPrincipalClass";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"isJsonWebToken:true");
    }

    @RunAsClient
    @Test(groups={"ee-security-optional"}, description="Validate a request without an MP-JWT to endpoint requiring role mapping has HTTP_OK")
    public void testNeedsGroup1Mapping() {
        Reporter.log((String)"testNeedsGroup1Mapping, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/needsGroup1Mapping";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @RunAsClient
    @Test(groups={"cdi"}, description="Validate that accessing secured method has HTTP_OK and injected JsonWebToken principal")
    public void getInjectedPrincipal() {
        Reporter.log((String)"getInjectedPrincipal, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/getInjectedPrincipal";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"isJsonWebToken:true");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request without an MP-JWT to unsecured endpoint has HTTP_OK with expected response")
    public void callHeartbeat() {
        Reporter.log((String)"callHeartbeat, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/heartbeat";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertTrue((boolean)reply.startsWith("Heartbeat:"), (String)"Saw Heartbeat: ...");
    }
}

