/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.JsonValuejectionEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class JsonValueInjectionTest
extends Arquillian {
    private static String token;
    private static Long iatClaim;
    private static Long authTimeClaim;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = JsonValueInjectionTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = JsonValueInjectionTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"JsonValueInjectionTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(JsonValuejectionEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        HashMap timeClaims = new HashMap();
        token = TokenUtils.generateTokenString((String)"/Token1.json", null, timeClaims);
        iatClaim = (Long)timeClaims.get(Claims.iat.name());
        authTimeClaim = (Long)timeClaims.get(Claims.auth_time.name());
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected token issuer claim is as expected")
    public void verifyIssuerClaim() throws Exception {
        Reporter.log((String)"Begin verifyIssuerClaim");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuer";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iss.name(), new Object[]{"https://server.example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedRawToken() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawToken\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.raw_token.name(), new Object[]{token}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected jti claim is as expected")
    public void verifyInjectedJTI() throws Exception {
        Reporter.log((String)"Begin verifyInjectedJTI\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedJTI";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.jti.name(), new Object[]{"a-123"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected aud claim is as expected")
    public void verifyInjectedAudience() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAudience\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), new Object[]{"s6BhdRkqt3"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedAuthTime() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAuthTime\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAuthTime";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected iat claim is as expected")
    public void verifyInjectedIssuedAt() throws Exception {
        Reporter.log((String)"Begin verifyInjectedIssuedAt\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuedAt";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iat.name(), new Object[]{iatClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customString claim is as expected")
    public void verifyInjectedCustomString() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomString\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomString";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"customStringValue"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customInteger claim is as expected")
    public void verifyInjectedCustomInteger() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomInteger\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomInteger";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{123456789}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customDouble claim is as expected")
    public void verifyInjectedCustomDouble() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomDouble\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomDouble";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{Math.PI}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customStringArray claim is as expected")
    public void verifyInjectedCustomStringArray() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomStringArray\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomStringArray";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"value0", "value1", "value2"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customIntegerArray claim is as expected")
    public void verifyInjectedCustomIntegerArray() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomIntegerArray\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomIntegerArray";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{0, 1, 2, 3}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customDoubleArray claim is as expected")
    public void verifyInjectedCustomDoubleArray() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomIntegerArray\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomDoubleArray";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{0.1, 1.1, 2.2, 3.3, 4.4}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected token issuer claim is as expected from Token2")
    public void verifyIssuerClaim2() throws Exception {
        Reporter.log((String)"Begin verifyIssuerClaim2");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuer";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iss.name(), new Object[]{"https://server.example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected raw token claim is as expected from Token2")
    public void verifyInjectedRawToken2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawToken2\n");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.raw_token.name(), new Object[]{token2}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected jti claim is as expected from Token2")
    public void verifyInjectedJTI2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedJTI2\n");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedJTI";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.jti.name(), new Object[]{"a-123.2"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected aud claim is as expected from Token2")
    public void verifyInjectedAudience2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAudience2\n");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), new Object[]{"s6BhdRkqt3.2"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected iat claim is as expected from Token2")
    public void verifyInjectedIssuedAt2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedIssuedAt2\n");
        HashMap timeClaims = new HashMap();
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json", null, timeClaims);
        Long iatClaim = (Long)timeClaims.get(Claims.auth_time.name());
        Long authTimeClaim = (Long)timeClaims.get(Claims.auth_time.name());
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuedAt";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iat.name(), new Object[]{iatClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected auth_time is as expected from Token2")
    public void verifyInjectedAuthTime2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAuthTime2\n");
        HashMap timeClaims = new HashMap();
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json", null, timeClaims);
        Long authTimeClaim = (Long)timeClaims.get(Claims.auth_time.name());
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAuthTime";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customString claim is as expected from Token2")
    public void verifyInjectedCustomString2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomString2\n");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomString";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"customStringValue2"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customInteger claim is as expected from Token2")
    public void verifyInjectedCustomInteger2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomInteger2\n");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomInteger";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{1234567892}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-json"}, description="Verify that the injected customDouble claim is as expected")
    public void verifyInjectedCustomDouble2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomDouble2\n");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomDouble";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{3.241592653589793}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token2)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

