/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryHistogramMetric;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryLongMetric;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;
import org.testng.Assert;

public class TelemetryMetricGetter {
    private final String classMethodName;
    private Map<TelemetryMetricID, TelemetryLongMetric> longMetrics = new HashMap<TelemetryMetricID, TelemetryLongMetric>();
    private Map<TelemetryMetricID, TelemetryHistogramMetric> histogramMetrics = new HashMap<TelemetryMetricID, TelemetryHistogramMetric>();

    public TelemetryMetricGetter(Class<?> clazz, String methodName) {
        this.validateClassAndMethodName(clazz, methodName);
        this.classMethodName = clazz.getCanonicalName() + "." + methodName;
    }

    public TelemetryLongMetric getInvocations(TelemetryMetricDefinition.InvocationResult result, TelemetryMetricDefinition.InvocationFallback fallbackUsed) {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.INVOCATIONS, result, fallbackUsed));
    }

    public TelemetryLongMetric getRetryCalls(TelemetryMetricDefinition.RetryRetried retried, TelemetryMetricDefinition.RetryResult result) {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.RETRY_CALLS, retried, result));
    }

    public TelemetryLongMetric getRetryRetries() {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.RETRY_RETRIES, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public TelemetryLongMetric getTimeoutCalls(TelemetryMetricDefinition.TimeoutTimedOut timedOut) {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.TIMEOUT_CALLS, timedOut));
    }

    public TelemetryHistogramMetric getTimeoutExecutionDuration() {
        return this.getHistogramMetric(this.getMetricId(TelemetryMetricDefinition.TIMEOUT_EXECUTION_DURATION, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public TelemetryLongMetric getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult cbResult) {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.CIRCUITBREAKER_CALLS, cbResult));
    }

    public TelemetryLongMetric getCircuitBreakerOpened() {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.CIRCUITBREAKER_OPENED, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public TelemetryLongMetric getCircuitBreakerState(TelemetryMetricDefinition.CircuitBreakerState cbState) {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.CIRCUITBREAKER_STATE, cbState));
    }

    public TelemetryLongMetric getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult bulkheadResult) {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.BULKHEAD_CALLS, bulkheadResult));
    }

    public TelemetryLongMetric getBulkheadExecutionsRunning() {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.BULKHEAD_EXECUTIONS_RUNNING, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public TelemetryLongMetric getBulkheadExecutionsWaiting() {
        return this.getLongMetric(this.getMetricId(TelemetryMetricDefinition.BULKHEAD_EXECUTIONS_WAITING, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public TelemetryHistogramMetric getBulkheadRunningDuration() {
        return this.getHistogramMetric(this.getMetricId(TelemetryMetricDefinition.BULKHEAD_RUNNING_DURATION, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public TelemetryHistogramMetric getBulkheadWaitingDuration() {
        return this.getHistogramMetric(this.getMetricId(TelemetryMetricDefinition.BULKHEAD_WAITING_DURATION, new TelemetryMetricDefinition.AttributeValue[0]));
    }

    public void baselineMetrics() {
        for (TelemetryMetricDefinition definition : TelemetryMetricDefinition.values()) {
            for (TelemetryMetricDefinition.AttributeValue[] tags : TelemetryMetricGetter.getTagCombinations(definition.getAttributeClasses())) {
                TelemetryMetricID id = this.getMetricId(definition, tags);
                if (definition.getMetricType() != TelemetryMetricDefinition.MetricType.COUNTER && definition.getMetricType() != TelemetryMetricDefinition.MetricType.GAUGE && definition.getMetricType() != TelemetryMetricDefinition.MetricType.UPDOWNCOUNTER) continue;
                this.getLongMetric(id).baseline();
            }
        }
    }

    @SafeVarargs
    public static final TelemetryMetricDefinition.AttributeValue[][] getTagCombinations(Class<? extends TelemetryMetricDefinition.AttributeValue> ... tagValueClazzes) {
        int combinations = 1;
        for (Class<? extends TelemetryMetricDefinition.AttributeValue> clazz : tagValueClazzes) {
            combinations *= clazz.getEnumConstants().length;
        }
        TelemetryMetricDefinition.AttributeValue[][] result = new TelemetryMetricDefinition.AttributeValue[combinations][];
        List<List<TelemetryMetricDefinition.AttributeValue>> tagLists = TelemetryMetricGetter.getTagCombinations(Arrays.asList(tagValueClazzes));
        for (int i = 0; i < tagLists.size(); ++i) {
            List<TelemetryMetricDefinition.AttributeValue> tagList = tagLists.get(i);
            result[i] = tagList.toArray(new TelemetryMetricDefinition.AttributeValue[tagList.size()]);
        }
        return result;
    }

    private static List<List<TelemetryMetricDefinition.AttributeValue>> getTagCombinations(List<Class<? extends TelemetryMetricDefinition.AttributeValue>> tagValueClazzes) {
        if (tagValueClazzes.isEmpty()) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList<List<TelemetryMetricDefinition.AttributeValue>> result = new ArrayList<List<TelemetryMetricDefinition.AttributeValue>>();
        Class<? extends TelemetryMetricDefinition.AttributeValue> firstClazz = tagValueClazzes.get(0);
        for (TelemetryMetricDefinition.AttributeValue value : firstClazz.getEnumConstants()) {
            for (List<TelemetryMetricDefinition.AttributeValue> tagList : TelemetryMetricGetter.getTagCombinations(tagValueClazzes.subList(1, tagValueClazzes.size()))) {
                ArrayList<TelemetryMetricDefinition.AttributeValue> newList = new ArrayList<TelemetryMetricDefinition.AttributeValue>();
                newList.add(value);
                newList.addAll(tagList);
                result.add(newList);
            }
        }
        return result;
    }

    private TelemetryMetricID getMetricId(TelemetryMetricDefinition metricDefinition, TelemetryMetricDefinition.AttributeValue ... metricAttributes) {
        if (metricDefinition.getAttributeClasses().length != metricAttributes.length) {
            throw new IllegalArgumentException("Wrong number of arguments passed for " + (Object)((Object)metricDefinition));
        }
        AttributesBuilder builder = Attributes.builder();
        for (int i = 0; i < metricAttributes.length; ++i) {
            Class<? extends TelemetryMetricDefinition.AttributeValue> argClazz = metricDefinition.getAttributeClasses()[i];
            if (!argClazz.isInstance(metricAttributes[i])) {
                throw new IllegalArgumentException("Argument " + i + " has the wrong type. Was " + metricAttributes[i].getClass() + " but expected " + argClazz);
            }
            builder.putAll(metricAttributes[i].getAttribute());
        }
        builder.put("method", this.classMethodName);
        return new TelemetryMetricID(metricDefinition.getName(), metricDefinition.getMetricType(), builder.build());
    }

    private TelemetryLongMetric getLongMetric(TelemetryMetricID metricId) {
        return this.longMetrics.computeIfAbsent(metricId, m -> new TelemetryLongMetric((TelemetryMetricID)m));
    }

    private TelemetryHistogramMetric getHistogramMetric(TelemetryMetricID metricId) {
        return this.histogramMetrics.computeIfAbsent(metricId, m -> new TelemetryHistogramMetric((TelemetryMetricID)m));
    }

    private void validateClassAndMethodName(Class<?> clazz, String methodName) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return;
        }
        Assert.fail((String)("Couldn't find method " + methodName + " on class " + clazz.getCanonicalName()));
    }
}

