/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;

public class TelemetryHistogramMetric {
    public static final List<Double> EXPECTED_BOUNDARIES = Arrays.asList(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0);
    private final TelemetryMetricID metricId;
    private final double MINIMUM_UPPER_BOUND_SECONDS;

    public TelemetryHistogramMetric(TelemetryMetricID metricId) {
        this.metricId = metricId;
        this.MINIMUM_UPPER_BOUND_SECONDS = (double)TCKConfig.getConfig().getTimeoutInMillis(200L) / 1000.0;
    }

    public Optional<HistogramPointData> getHistogramPoint() {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        return reader.getMetric(this.metricId).flatMap(md -> InMemoryMetricReader.getHistogramPointData(md, this.metricId));
    }

    public Optional<Long> getHistogramCount() {
        return this.getHistogramPoint().map(HistogramPointData::getCount);
    }

    public boolean isPresent() {
        return this.getHistogramPoint().isPresent();
    }

    public void assertBoundaries() {
        HistogramPointData pointData = this.getHistogramPoint().orElseThrow(() -> new AssertionError((Object)("No data point for " + this.metricId)));
        MatcherAssert.assertThat((Object)pointData.getBoundaries(), (Matcher)Matchers.equalTo(EXPECTED_BOUNDARIES));
    }

    public void assertBucketCounts(long ... expectedResultsMillis) {
        HistogramPointData pointData = this.getHistogramPoint().orElseThrow(() -> new AssertionError((Object)("No data point for " + this.metricId)));
        Assert.assertEquals((long)pointData.getCount(), (long)expectedResultsMillis.length, (String)("Wrong number of results in histogram getCounts for " + this.metricId));
        Assert.assertEquals((long)pointData.getCounts().stream().mapToLong(Long::longValue).sum(), (long)expectedResultsMillis.length, (String)("Wrong number of results in histogram buckets for " + this.metricId));
        ArrayList<Long> minCounts = new ArrayList<Long>(pointData.getCounts());
        minCounts.replaceAll(x -> 0L);
        ArrayList<Long> maxCounts = new ArrayList<Long>(pointData.getCounts());
        maxCounts.replaceAll(x -> 0L);
        List expectedResultsSeconds = Arrays.stream(expectedResultsMillis).mapToDouble(millis -> (double)TCKConfig.getConfig().getTimeoutInMillis(millis) / 1000.0).boxed().collect(Collectors.toList());
        Iterator iterator = expectedResultsSeconds.iterator();
        while (iterator.hasNext()) {
            int maxBucket;
            double expectedResult = (Double)iterator.next();
            int minBucket = TelemetryHistogramMetric.findBucket(pointData.getBoundaries(), expectedResult * 0.8);
            if (minBucket == (maxBucket = TelemetryHistogramMetric.findBucket(pointData.getBoundaries(), Double.max(expectedResult * 1.2, this.MINIMUM_UPPER_BOUND_SECONDS)))) {
                minCounts.set(minBucket, (Long)minCounts.get(minBucket) + 1L);
                maxCounts.set(minBucket, (Long)maxCounts.get(minBucket) + 1L);
                continue;
            }
            for (int i = minBucket; i <= maxBucket; ++i) {
                maxCounts.set(i, (Long)maxCounts.get(i) + 1L);
            }
        }
        ArrayList<Integer> wrongCountBuckets = new ArrayList<Integer>();
        List actualCounts = pointData.getCounts();
        for (int i = 0; i < actualCounts.size(); ++i) {
            if ((Long)actualCounts.get(i) >= (Long)minCounts.get(i) && (Long)actualCounts.get(i) <= (Long)maxCounts.get(i)) continue;
            wrongCountBuckets.add(i);
        }
        if (!wrongCountBuckets.isEmpty()) {
            Assert.fail((String)("For metric " + this.metricId + "\nThe following buckets have incorrect counts " + ((Object)wrongCountBuckets).toString() + "\n      Bucket boundaries: " + pointData.getBoundaries() + "\n     Expected times (s): " + expectedResultsSeconds + "\nExpected minimum counts: " + minCounts + "\nExpected maximum counts: " + maxCounts + "\n   Actual bucket counts: " + actualCounts));
        }
    }

    public static int findBucket(List<Double> boundaries, double value) {
        for (int i = 0; i < boundaries.size(); ++i) {
            if (!(value <= boundaries.get(i))) continue;
            return i;
        }
        return boundaries.size();
    }
}

