/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import jakarta.inject.Inject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadFutureClassBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadFutureMethodBean;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BulkheadFutureTest
extends Arquillian {
    @Inject
    private BulkheadFutureMethodBean bhFutureMethodBean;
    @Inject
    private BulkheadFutureClassBean bhFutureClassBean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadFutureTest.jar")).addClasses(new Class[]{BulkheadFutureMethodBean.class, BulkheadFutureClassBean.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadFutureTest.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testBulkheadMethodAsynchFutureDoneAfterGet() throws InterruptedException, ExecutionException, TimeoutException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            TestFuture testFuture = new TestFuture();
            Barrier barrier = taskManager.newBarrier();
            Future<String> result = this.bhFutureMethodBean.test(testFuture, barrier);
            Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
            barrier.open();
            Assert.assertEquals((String)result.get(10L, TimeUnit.SECONDS), (String)"RESULT");
            Assert.assertEquals((String)result.get(), (String)"RESULT");
            Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
        }
    }

    @Test
    public void testBulkheadMethodAsynchFutureDoneWithoutGet() {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            TestFuture testFuture = new TestFuture();
            Barrier barrier = taskManager.newBarrier();
            Future<String> result = this.bhFutureMethodBean.test(testFuture, barrier);
            Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
            barrier.open();
            Awaitility.await((String)"Future reports done").until(() -> result.isDone());
        }
    }

    @Test
    public void testBulkheadClassAsynchFutureDoneAfterGet() throws InterruptedException, ExecutionException, TimeoutException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            TestFuture testFuture = new TestFuture();
            Barrier barrier = taskManager.newBarrier();
            Future<String> result = this.bhFutureClassBean.test(testFuture, barrier);
            Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
            barrier.open();
            Assert.assertEquals((String)result.get(10L, TimeUnit.SECONDS), (String)"RESULT");
            Assert.assertEquals((String)result.get(), (String)"RESULT");
            Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
        }
    }

    @Test
    public void testBulkheadClassAsynchFutureDoneWithoutGet() {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            TestFuture testFuture = new TestFuture();
            Barrier barrier = taskManager.newBarrier();
            Future<String> result = this.bhFutureClassBean.test(testFuture, barrier);
            Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
            barrier.open();
            Awaitility.await((String)"Future reports done").until(() -> result.isDone());
        }
    }

    public static final class TestFuture
    implements Future<String> {
        private boolean isCancelled;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public String get() {
            return "RESULT";
        }

        @Override
        public String get(long timeout, TimeUnit unit) {
            return "RESULT";
        }
    }
}

