/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.CircuitBreakerMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CircuitBreakerTelemetryTest
extends Arquillian {
    private static final long CB_CLOSE_TIMEOUT = TCKConfig.getConfig().getTimeoutInDuration(5000).toNanos();
    @Inject
    private CircuitBreakerMetricBean cbBean;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(CircuitBreakerMetricBean.class, "doWork");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricCircuitBreaker.jar")).addClasses(new Class[]{CircuitBreakerMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricCircuitBreaker.war")).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=none"), "META-INF/microprofile-config.properties")).addAsLibrary((Archive)jar)).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        return war;
    }

    @BeforeTest
    public void closeTheCircuit() throws Exception {
        if (this.cbBean != null) {
            boolean circuitOpen = true;
            long startTime = System.nanoTime();
            while (circuitOpen && System.nanoTime() - startTime < CB_CLOSE_TIMEOUT) {
                try {
                    for (int i = 0; i < 2; ++i) {
                        this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS);
                    }
                    circuitOpen = false;
                }
                catch (CircuitBreakerOpenException e) {
                    Thread.sleep(100L);
                }
            }
            if (circuitOpen) {
                throw new RuntimeException("Timed out waiting for circuit breaker to close");
            }
        }
    }

    @Test(groups={"main"})
    public void testCircuitBreakerMetric() throws Exception {
        TelemetryMetricGetter m = new TelemetryMetricGetter(CircuitBreakerMetricBean.class, "doWork");
        Exceptions.expectTestException(() -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.FAIL));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)0L));
        Exceptions.expectTestException(() -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.FAIL));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Exceptions.expectCbOpen(() -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(5000L));
        for (int i = 0; i < 2; ++i) {
            this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS);
        }
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Exceptions.expect(RuntimeException.class, () -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS_EXCEPTION));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Exceptions.expect(CircuitBreakerMetricBean.SkippedException.class, () -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.SKIPPED_EXCEPTION));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)5L));
    }

    @Test(dependsOnGroups={"main"})
    public void testMetricUnits() throws InterruptedException, ExecutionException {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        for (TelemetryMetricDefinition metric : TelemetryMetricDefinition.values()) {
            if (!metric.getName().startsWith("ft.circuitbreaker")) continue;
            String unit = reader.getUnit(metric.getName());
            if (metric.getUnit() == null) {
                Assert.assertTrue((boolean)unit.isEmpty(), (String)("Unexpected metadata for metric " + metric.getName()));
                continue;
            }
            Assert.assertFalse((boolean)unit.isEmpty(), (String)("Missing metadata for metric " + metric.getName()));
            Assert.assertEquals((String)unit, (String)metric.getUnit(), (String)("Incorrect unit for metric " + metric.getName()));
        }
    }
}

