/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver;

import jakarta.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.StringFallbackHandler;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@RequestScoped
public class FallbackClient {
    private int counterForInvokingServiceA = 0;
    private int counterForInvokingServiceB = 0;
    private int counterForInvokingServiceC = 0;
    private int counterForInvokingServiceD = 0;
    private int counterForInvokingServiceE = 0;

    public int getCounterForInvokingServiceA() {
        return this.counterForInvokingServiceA;
    }

    public int getCounterForInvokingServiceB() {
        return this.counterForInvokingServiceB;
    }

    public int getCounterForInvokingServiceC() {
        return this.counterForInvokingServiceC;
    }

    public int getCounterForInvokingServiceD() {
        return this.counterForInvokingServiceD;
    }

    public int getCounterForInvokingServiceE() {
        return this.counterForInvokingServiceE;
    }

    @Retry(maxRetries=1)
    @Fallback(value=StringFallbackHandler.class)
    public String serviceA() {
        ++this.counterForInvokingServiceA;
        return this.nameService();
    }

    @Retry(maxRetries=2)
    @Fallback(value=StringFallbackHandler.class)
    public String serviceB() {
        ++this.counterForInvokingServiceB;
        return this.nameService();
    }

    @Timeout(value=500L)
    @Retry(maxRetries=1)
    @Fallback(value=StringFallbackHandler.class)
    public String serviceC(long timeToSleep) {
        try {
            ++this.counterForInvokingServiceC;
            Thread.sleep(timeToSleep);
            throw new RuntimeException("Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Retry(maxRetries=1)
    @Fallback(fallbackMethod="fallbackForServiceD")
    public String serviceD() {
        ++this.counterForInvokingServiceD;
        return this.nameService();
    }

    public String fallbackForServiceD() {
        return "fallback method for serviceD";
    }

    @Retry(maxRetries=1)
    @Fallback(fallbackMethod="fallbackForServiceE")
    public String serviceE(String name, Integer type) {
        ++this.counterForInvokingServiceE;
        return this.nameService();
    }

    public String fallbackForServiceE(String name, Integer type) {
        return "fallback method for serviceE";
    }

    private String nameService() {
        throw new TestException("Connection failed");
    }
}

