/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.text.SimpleDateFormat;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.datafeed.BubbleEntry;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.impl.BubbleDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.DataSetImpl;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.NumberUtil;

public class BubbleDataSetProcessorImpl
extends DataSetAdapter {
    public Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        CDateTime cMax = null;
        double dMax = -1.7976931348623157E308;
        Number bnMax = null;
        int i = 0;
        while (dsi.hasNext()) {
            Object oValue;
            BubbleEntry bde = (BubbleEntry)((Object)dsi.next());
            if (bde != null && (oValue = bde.getValue()) != null) {
                if (NumberUtil.isBigNumber((Object)oValue)) {
                    BigNumber bnValue = (BigNumber)oValue;
                    if (bde.getSizeNumber() != null) {
                        bnValue = bnValue.add((BigNumber)bde.getSizeNumber());
                    }
                    bnMax = bnMax == null ? bnValue : ((BigNumber)bnMax).max(bnValue);
                } else if (oValue instanceof com.ibm.icu.math.BigDecimal) {
                    com.ibm.icu.math.BigDecimal bnValue = (com.ibm.icu.math.BigDecimal)oValue;
                    if (bde.getSizeNumber() != null) {
                        bnValue = bnValue.add((com.ibm.icu.math.BigDecimal)bde.getSizeNumber());
                    }
                    bnMax = bnMax == null ? bnValue : ((com.ibm.icu.math.BigDecimal)bnMax).max(bnValue);
                } else if (oValue instanceof BigDecimal) {
                    BigDecimal bnValue = (BigDecimal)oValue;
                    if (bde.getSizeNumber() != null) {
                        bnValue = bnValue.add((BigDecimal)bde.getSizeNumber());
                    }
                    bnMax = bnMax == null ? bnValue : ((BigDecimal)bnMax).max(bnValue);
                } else if (oValue instanceof Number) {
                    double dValue = ((Number)oValue).doubleValue();
                    dMax = i == 0 ? dValue : Math.max(dMax, dValue);
                } else if (oValue instanceof CDateTime) {
                    CDateTime cValue = (CDateTime)oValue;
                    if (i == 0) {
                        cMax = cValue;
                    } else if (cValue.after((Object)cMax)) {
                        cMax = cValue;
                    }
                }
            }
            ++i;
        }
        if (cMax == null) {
            return bnMax != null ? (Number)bnMax : (Number)new Double(dMax);
        }
        return cMax;
    }

    public Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        CDateTime cMin = null;
        double dMin = Double.MAX_VALUE;
        Number bnMin = null;
        int i = 0;
        while (dsi.hasNext()) {
            Object oValue;
            BubbleEntry bde = (BubbleEntry)((Object)dsi.next());
            if (bde != null && (oValue = bde.getValue()) != null) {
                if (NumberUtil.isBigNumber((Object)oValue)) {
                    BigNumber bnValue = (BigNumber)oValue;
                    if (bde.getSizeNumber() != null) {
                        bnValue = bnValue.subtract((BigNumber)bde.getSizeNumber());
                    }
                    bnMin = bnMin == null ? bnValue : ((BigNumber)bnMin).min(bnValue);
                } else if (oValue instanceof com.ibm.icu.math.BigDecimal) {
                    com.ibm.icu.math.BigDecimal bnValue = (com.ibm.icu.math.BigDecimal)oValue;
                    if (bde.getSizeNumber() != null) {
                        bnValue = bnValue.subtract((com.ibm.icu.math.BigDecimal)bde.getSizeNumber());
                    }
                    bnMin = bnMin == null ? bnValue : ((com.ibm.icu.math.BigDecimal)bnMin).min(bnValue);
                } else if (oValue instanceof BigDecimal) {
                    BigDecimal bnValue = (BigDecimal)oValue;
                    if (bde.getSizeNumber() != null) {
                        bnValue = bnValue.subtract((BigDecimal)bde.getSizeNumber());
                    }
                    bnMin = bnMin == null ? bnValue : ((BigDecimal)bnMin).min(bnValue);
                } else if (oValue instanceof Number) {
                    double dValue = ((Number)oValue).doubleValue();
                    dMin = i == 0 ? dValue : Math.min(dMin, dValue);
                } else if (oValue instanceof CDateTime) {
                    CDateTime cValue = (CDateTime)oValue;
                    if (i == 0) {
                        cMin = cValue;
                    } else if (cValue.before((Object)cMin)) {
                        cMin = cValue;
                    }
                }
            }
            ++i;
        }
        if (cMin == null) {
            return bnMin != null ? (Number)bnMin : (Number)new Double(dMin);
        }
        return cMin;
    }

    /*
     * Unable to fully structure code
     */
    public final DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        block7: {
            block5: {
                block6: {
                    if (!(oResultSetDef instanceof IResultSetDataSet)) break block5;
                    rsds = (IResultSetDataSet)oResultSetDef;
                    lRowCount = rsds.getSize();
                    if (lRowCount <= 0L) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
                    }
                    dataType = rsds.getDataType(0);
                    isBigDecimal = false;
                    i = 0;
                    bea = new BubbleEntry[(int)lRowCount];
                    if (dataType != 1) ** GOTO lbl25
                    while (rsds.hasNext()) {
                        o = rsds.next();
                        this.validateBubbleEntryData(o);
                        bea[i++] = new BubbleEntry(NumberUtil.convertNumber((Object)o[0]), NumberUtil.convertNumber((Object)o[1]));
                        if ((isBigDecimal || !NumberUtil.isBigDecimal((Object)o[0])) && !NumberUtil.isBigDecimal((Object)o[1])) continue;
                        isBigDecimal = true;
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        o = rsds.next();
                        this.validateBubbleEntryData(o);
                        value = o[0];
                        size = o[1];
                        bea[i] = dataType == 8 ? new BubbleEntry(value == null ? null : value, size) : new BubbleEntry(value, size, i + 1);
                        ++i;
lbl25:
                        // 2 sources

                        ** while (rsds.hasNext())
                    }
                }
                if (ds == null) {
                    ds = BubbleDataSetImpl.create((Object)bea);
                } else {
                    ds.setValues((Object)bea);
                }
                break block7;
            }
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", new Object[]{ds, oResultSetDef}, Messages.getResourceBundle(this.getULocale()));
        }
        ((DataSetImpl)ds).setIsBigNumber(isBigDecimal);
        return ds;
    }

    private void validateBubbleEntryData(Object[] obja) throws ChartException {
        boolean valid = true;
        if (obja == null) {
            valid = false;
        } else if (obja.length != 2) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.dataset.bubbleseries", Messages.getResourceBundle(this.getULocale()));
        }
        if (!valid) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 30, "exception.dataset.null.bubbleentry", Messages.getResourceBundle(this.getULocale()));
        }
    }

    public final DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        if (ds == null) {
            ds = BubbleDataSetImpl.create(null);
        }
        StringTokenizer strTokDataElement = new StringTokenizer(sDataSetRepresentation, ",");
        StringTokenizer strTokComponents = null;
        String strDataElement = null;
        String strComponent = null;
        Vector<BubbleEntry> vData = new Vector<BubbleEntry>();
        int[] sizes = new int[]{3, 5, 4, 6, 4};
        int i = 0;
        while (strTokDataElement.hasMoreTokens()) {
            strDataElement = strTokDataElement.nextToken().trim();
            strTokComponents = new StringTokenizer(strDataElement);
            if (strTokComponents.countTokens() == 1) {
                Double value = null;
                try {
                    value = new Double(Double.parseDouble(strDataElement));
                }
                catch (NumberFormatException numberFormatException) {
                    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                    try {
                        value = new CDateTime(sdf.parse(strDataElement));
                    }
                    catch (ParseException parseException) {
                        value = null;
                    }
                }
                vData.add(new BubbleEntry(value, sizes[i++]));
                continue;
            }
            BubbleEntry entry = new BubbleEntry(1, 1);
            while (strTokComponents.hasMoreTokens()) {
                strComponent = strTokComponents.nextToken().trim().toUpperCase();
                if (strComponent.startsWith("Y")) {
                    entry.setValue(strComponent.substring(1));
                    continue;
                }
                if (!strComponent.startsWith("S")) continue;
                entry.setSize(Double.parseDouble(strComponent.substring(1)));
            }
            vData.add(entry);
        }
        ds.setValues(vData);
        return ds;
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.bubble.sample.format", this.getULocale());
    }

    public String toString(Object[] columnData) throws ChartException {
        if (columnData == null || columnData.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < columnData.length) {
            if (columnData[i] == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
            }
            if (columnData[i] instanceof Object[]) {
                buffer.append(this.toBubbleString((Object[])columnData[i]));
            }
            if (i < columnData.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private StringBuffer toBubbleString(Object[] bubbleArray) throws ChartException {
        if (bubbleArray.length != 2 || bubbleArray[0] == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "Invalid data set column");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Y" + String.valueOf(bubbleArray[0]) + " ");
        buffer.append("S" + String.valueOf(bubbleArray[1]));
        return buffer;
    }

    public int[] getDataDefIdsForGrouping(Series series) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }
}

