/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;

public class BlockedTaskFinder {
    private Set<ICompositeCheatSheetTask> stateChangedTasks;
    private Set<ICompositeCheatSheetTask> impactedTasks;

    public Set<ICompositeCheatSheetTask> findBlockedTaskChanges(Set<ICompositeCheatSheetTask> stateChangedTasks) {
        this.stateChangedTasks = stateChangedTasks;
        this.impactedTasks = new HashSet<ICompositeCheatSheetTask>();
        this.visitChangedTasks();
        this.findSuccesors();
        return this.impactedTasks;
    }

    private void visitChangedTasks() {
        for (ICompositeCheatSheetTask nextTask : this.stateChangedTasks) {
            if (nextTask.getState() == 1) continue;
            this.findUnstartedChildren(nextTask);
        }
    }

    private void findUnstartedChildren(ICompositeCheatSheetTask task) {
        ICompositeCheatSheetTask[] children;
        ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = children = task.getSubtasks();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeCheatSheetTask nextChild = iCompositeCheatSheetTaskArray[n2];
            if (!this.stateChangedTasks.contains(nextChild) && !this.impactedTasks.contains(nextChild)) {
                if (nextChild.getState() == 0) {
                    this.impactedTasks.add(nextChild);
                }
                this.findUnstartedChildren(nextChild);
            }
            ++n2;
        }
    }

    private void findSuccesors() {
        for (ICompositeCheatSheetTask iCompositeCheatSheetTask : this.stateChangedTasks) {
            ICompositeCheatSheetTask[] successors;
            AbstractTask nextTask = (AbstractTask)iCompositeCheatSheetTask;
            ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = successors = nextTask.getSuccessorTasks();
            int n = successors.length;
            int n2 = 0;
            while (n2 < n) {
                ICompositeCheatSheetTask nextSuccessor = iCompositeCheatSheetTaskArray[n2];
                if (nextSuccessor.getState() == 0) {
                    this.impactedTasks.add(nextSuccessor);
                }
                this.findUnstartedChildren(nextSuccessor);
                ++n2;
            }
        }
    }
}

