/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.QuotedTokenizer;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IFilterAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public abstract class AbstractPublisherAction
implements IPublisherAction {
    public static final String CONFIG_ANY = "ANY";
    public static final String CONFIG_SEGMENT_SEPARATOR = ".";
    protected IPublisherInfo info;

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        QuotedTokenizer tokens = new QuotedTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] parseConfigSpec(String configSpec) {
        String[] result = AbstractPublisherAction.getArrayFromString(configSpec, CONFIG_SEGMENT_SEPARATOR);
        int i = 0;
        while (i < result.length) {
            if (result[i].equals("*")) {
                result[i] = CONFIG_ANY;
            }
            ++i;
        }
        if (result.length < 3) {
            String[] temp = new String[3];
            System.arraycopy(result, 0, temp, 0, result.length);
            int i2 = result.length;
            while (i2 < temp.length) {
                temp[i2] = CONFIG_ANY;
                ++i2;
            }
            result = temp;
        }
        return result;
    }

    public static String createConfigSpec(String ws, String os, String arch) {
        return String.valueOf(ws) + '.' + os + '.' + arch;
    }

    protected void addSelfCapability(MetadataFactory.InstallableUnitDescription root) {
        root.setCapabilities(new IProvidedCapability[]{this.createSelfCapability(root.getId(), root.getVersion())});
    }

    protected IMatchExpression<IInstallableUnit> createFilterSpec(String configSpec) {
        String ldap = this.createLDAPString(configSpec);
        if (ldap == null) {
            return null;
        }
        return InstallableUnit.parseFilter((String)ldap);
    }

    protected String createLDAPString(String configSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        if (config[0] != null || config[1] != null || config[2] != null) {
            String filterArch;
            String filterWs = config[0] != null && !CONFIG_ANY.equalsIgnoreCase(config[0]) ? "(osgi.ws=" + config[0] + ")" : "";
            String filterOs = config[1] != null && !CONFIG_ANY.equalsIgnoreCase(config[1]) ? "(osgi.os=" + config[1] + ")" : "";
            String string = filterArch = config[2] != null && !CONFIG_ANY.equalsIgnoreCase(config[2]) ? "(osgi.arch=" + config[2] + ")" : "";
            if (filterWs.length() == 0 && filterOs.length() == 0 && filterArch.length() == 0) {
                return null;
            }
            return "(& " + filterWs + filterOs + filterArch + ")";
        }
        return null;
    }

    protected boolean filterMatches(IMatchExpression<IInstallableUnit> filter, String configSpec) {
        if (filter == null) {
            return true;
        }
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        return filter.isMatch((Object)InstallableUnit.contextIU((String)config[0], (String)config[1], (String)config[2]));
    }

    protected String createIdString(String configSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        return String.valueOf(config[0]) + '.' + config[1] + '.' + config[2];
    }

    protected String createCUIdString(String id, String type, String flavor, String configSpec) {
        return String.valueOf(flavor) + id + CONFIG_SEGMENT_SEPARATOR + type + CONFIG_SEGMENT_SEPARATOR + this.createIdString(configSpec);
    }

    protected Collection<IRequirement> createIURequirements(Collection<? extends IVersionedId> children) {
        ArrayList<IRequirement> result = new ArrayList<IRequirement>(children.size());
        for (IVersionedId iVersionedId : children) {
            VersionRange range;
            if (iVersionedId instanceof IInstallableUnit) {
                IInstallableUnit iu = (IInstallableUnit)iVersionedId;
                range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
                result.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)(iu.getFilter() == null ? null : iu.getFilter()), (boolean)false, (boolean)false));
                continue;
            }
            Version version = iVersionedId.getVersion();
            range = version == null || Version.emptyVersion.equals(version) ? VersionRange.emptyRange : new VersionRange(version, true, version, true);
            IMatchExpression<IInstallableUnit> filter = this.getFilterAdvice(iVersionedId);
            result.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iVersionedId.getId(), (VersionRange)range, filter, (boolean)false, (boolean)false));
        }
        return result;
    }

    private IMatchExpression<IInstallableUnit> getFilterAdvice(IVersionedId name) {
        if (this.info == null) {
            return null;
        }
        Collection<IFilterAdvice> filterAdvice = this.info.getAdvice(CONFIG_ANY, true, name.getId(), name.getVersion(), IFilterAdvice.class);
        for (IFilterAdvice advice : filterAdvice) {
            IMatchExpression<IInstallableUnit> result = advice.getFilter(name.getId(), name.getVersion(), false);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected MetadataFactory.InstallableUnitDescription createIUShell(String id, Version version) {
        MetadataFactory.InstallableUnitDescription root = new MetadataFactory.InstallableUnitDescription();
        root.setId(id);
        root.setVersion(version);
        return root;
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    protected IArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File pathOnDisk, String installSize) {
        ArtifactDescriptor result = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor(this.info, key, pathOnDisk);
        if (pathOnDisk != null) {
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(pathOnDisk.length()));
        }
        IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
        result.setProcessingSteps(steps);
        result.setProperty("format", "packed");
        return result;
    }

    protected MetadataFactory.InstallableUnitDescription createParentIU(Collection<? extends IVersionedId> children, String id, Version version) {
        MetadataFactory.InstallableUnitDescription root = this.createIUShell(id, version);
        root.addRequirements(this.createIURequirements(children));
        this.addSelfCapability(root);
        return root;
    }

    protected FileUtils.IPathComputer createParentPrefixComputer(int segmentsToKeep) {
        return FileUtils.createParentPrefixComputer((int)segmentsToKeep);
    }

    protected FileUtils.IPathComputer createRootPrefixComputer(File root) {
        return FileUtils.createRootPathComputer((File)root);
    }

    protected IProvidedCapability createSelfCapability(String installableUnitId, Version installableUnitVersion) {
        return MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)installableUnitId, (Version)installableUnitVersion);
    }

    protected static MetadataFactory.InstallableUnitDescription[] processAdditionalInstallableUnitsAdvice(IInstallableUnit iu, IPublisherInfo publisherInfo) {
        Collection<IAdditionalInstallableUnitAdvice> advice = publisherInfo.getAdvice(null, false, iu.getId(), iu.getVersion(), IAdditionalInstallableUnitAdvice.class);
        if (advice.isEmpty()) {
            return null;
        }
        ArrayList<MetadataFactory.InstallableUnitDescription> ius = new ArrayList<MetadataFactory.InstallableUnitDescription>();
        for (IAdditionalInstallableUnitAdvice entry : advice) {
            MetadataFactory.InstallableUnitDescription[] others = entry.getAdditionalInstallableUnitDescriptions(iu);
            if (others == null) continue;
            ius.addAll(Arrays.asList(others));
        }
        return ius.toArray(new MetadataFactory.InstallableUnitDescription[ius.size()]);
    }

    protected static void processArtifactPropertiesAdvice(IInstallableUnit iu, IArtifactDescriptor descriptor, IPublisherInfo info) {
        if (!(descriptor instanceof SimpleArtifactDescriptor)) {
            return;
        }
        Collection<IPropertyAdvice> advice = info.getAdvice(null, false, iu.getId(), iu.getVersion(), IPropertyAdvice.class);
        for (IPropertyAdvice entry : advice) {
            Map<String, String> props = entry.getArtifactProperties(iu, descriptor);
            if (props == null) continue;
            for (Map.Entry<String, String> pe : props.entrySet()) {
                ((SimpleArtifactDescriptor)descriptor).setRepositoryProperty(pe.getKey(), pe.getValue());
            }
        }
    }

    protected static void processInstallableUnitPropertiesAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo info) {
        Collection<IPropertyAdvice> advice = info.getAdvice(null, false, iu.getId(), iu.getVersion(), IPropertyAdvice.class);
        for (IPropertyAdvice entry : advice) {
            Map<String, String> props = entry.getInstallableUnitProperties(iu);
            if (props == null) continue;
            for (Map.Entry<String, String> pe : props.entrySet()) {
                iu.setProperty(pe.getKey(), pe.getValue());
            }
        }
    }

    protected static void processUpdateDescriptorAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo info) {
        Collection<IUpdateDescriptorAdvice> advice = info.getAdvice(null, false, iu.getId(), iu.getVersion(), IUpdateDescriptorAdvice.class);
        if (advice.isEmpty()) {
            return;
        }
        for (IUpdateDescriptorAdvice entry : advice) {
            IUpdateDescriptor updateDescriptor = entry.getUpdateDescriptor(iu);
            if (updateDescriptor == null) continue;
            iu.setUpdateDescriptor(updateDescriptor);
        }
    }

    protected static void processCapabilityAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo info) {
        Collection<ICapabilityAdvice> advice = info.getAdvice(null, false, iu.getId(), iu.getVersion(), ICapabilityAdvice.class);
        if (advice.isEmpty()) {
            return;
        }
        for (ICapabilityAdvice entry : advice) {
            IProvidedCapability[] providedAdvice;
            IRequirement[] iRequirementArray;
            IRequirement[] metaRequiredAdvice;
            int n;
            IRequirement[] requiredAdvice = entry.getRequiredCapabilities(iu);
            if (requiredAdvice != null) {
                List current = iu.getRequirements();
                HashSet<IRequirement> resultRequiredCapabilities = new HashSet<IRequirement>(current);
                block1: for (IRequirement currReq : current) {
                    IRequiredCapability currentRequiredCapability = AbstractPublisherAction.toRequiredCapability(currReq);
                    if (currentRequiredCapability == null) continue;
                    IRequirement[] iRequirementArray2 = requiredAdvice;
                    n = requiredAdvice.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRequirement currReqAdvice = iRequirementArray2[n2];
                        IRequiredCapability requiredCapability = AbstractPublisherAction.toRequiredCapability(currReqAdvice);
                        if (requiredCapability != null && requiredCapability.getNamespace().equals(currentRequiredCapability.getNamespace()) && requiredCapability.getName().equals(currentRequiredCapability.getName())) {
                            resultRequiredCapabilities.remove(currentRequiredCapability);
                            continue block1;
                        }
                        ++n2;
                    }
                }
                resultRequiredCapabilities.addAll(Arrays.asList(requiredAdvice));
                iu.setRequirements(resultRequiredCapabilities.toArray(new IRequirement[resultRequiredCapabilities.size()]));
            }
            if ((metaRequiredAdvice = entry.getMetaRequiredCapabilities(iu)) != null) {
                Collection current = iu.getMetaRequirements();
                HashSet<IRequirement> resultMetaRequiredCapabilities = new HashSet<IRequirement>(current);
                block3: for (IRequirement currMetaReq : current) {
                    IRequiredCapability currentMetaRequiredCapability = AbstractPublisherAction.toRequiredCapability(currMetaReq);
                    if (currentMetaRequiredCapability == null) continue;
                    iRequirementArray = metaRequiredAdvice;
                    int n3 = metaRequiredAdvice.length;
                    n = 0;
                    while (n < n3) {
                        IRequirement currMetaReqAdvice = iRequirementArray[n];
                        IRequiredCapability metaRequiredCapability = AbstractPublisherAction.toRequiredCapability(currMetaReqAdvice);
                        if (metaRequiredCapability != null && metaRequiredCapability.getNamespace().equals(currentMetaRequiredCapability.getNamespace()) && metaRequiredCapability.getName().equals(currentMetaRequiredCapability.getName())) {
                            resultMetaRequiredCapabilities.remove(currentMetaRequiredCapability);
                            continue block3;
                        }
                        ++n;
                    }
                }
                resultMetaRequiredCapabilities.addAll(Arrays.asList(metaRequiredAdvice));
                iu.setMetaRequirements(resultMetaRequiredCapabilities.toArray(new IRequirement[resultMetaRequiredCapabilities.size()]));
            }
            if ((providedAdvice = entry.getProvidedCapabilities(iu)) == null) continue;
            Collection current = iu.getProvidedCapabilities();
            HashSet<IProvidedCapability> resultProvidedCapabilities = new HashSet<IProvidedCapability>(current);
            block5: for (IProvidedCapability currentProvidedCapability : current) {
                iRequirementArray = providedAdvice;
                int n4 = providedAdvice.length;
                n = 0;
                while (n < n4) {
                    IRequirement providedCapability = iRequirementArray[n];
                    if (providedCapability.getNamespace().equals(currentProvidedCapability.getNamespace()) && providedCapability.getName().equals(currentProvidedCapability.getName())) {
                        resultProvidedCapabilities.remove(currentProvidedCapability);
                        continue block5;
                    }
                    ++n;
                }
            }
            resultProvidedCapabilities.addAll(Arrays.asList(providedAdvice));
            iu.setCapabilities(resultProvidedCapabilities.toArray(new IProvidedCapability[resultProvidedCapabilities.size()]));
        }
    }

    protected static IRequiredCapability toRequiredCapability(IRequirement requirement) {
        if (!(requirement instanceof IRequiredCapability)) {
            return null;
        }
        IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
        if (!RequiredCapability.isVersionRangeRequirement((IMatchExpression)requiredCapability.getMatches())) {
            return null;
        }
        return requiredCapability;
    }

    protected static void processTouchpointAdvice(MetadataFactory.InstallableUnitDescription iu, Map<String, ? extends Object> currentInstructions, IPublisherInfo info) {
        AbstractPublisherAction.processTouchpointAdvice(iu, currentInstructions, info, null);
    }

    protected static void processTouchpointAdvice(MetadataFactory.InstallableUnitDescription iu, Map<String, ? extends Object> currentInstructions, IPublisherInfo info, String configSpec) {
        Collection<ITouchpointAdvice> advice = info.getAdvice(configSpec, false, iu.getId(), iu.getVersion(), ITouchpointAdvice.class);
        if (currentInstructions == null) {
            if (advice == null || advice.isEmpty()) {
                return;
            }
            currentInstructions = Collections.emptyMap();
        }
        ITouchpointData result = MetadataFactory.createTouchpointData(currentInstructions);
        if (advice != null) {
            for (ITouchpointAdvice entry : advice) {
                result = entry.getTouchpointData(result);
            }
        }
        iu.addTouchpointData(result);
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File inclusion, IPublisherInfo publisherInfo) {
        File descriptorFile;
        if (inclusion == null) {
            return;
        }
        IArtifactRepository destination = publisherInfo.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        if ((publisherInfo.getArtifactOptions() & 2) == 0) {
            destination.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        if (destination instanceof IFileArtifactRepository && inclusion.equals(descriptorFile = ((IFileArtifactRepository)destination).getArtifactFile(descriptor))) {
            destination.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        try {
            OutputStream output = destination.getOutputStream(descriptor);
            if (output == null) {
                return;
            }
            output = new BufferedOutputStream(output);
            FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(inclusion)), (boolean)true, (OutputStream)output, (boolean)true);
        }
        catch (ProvisionException e) {
            LogHelper.log((IStatus)e.getStatus());
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
        }
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File[] inclusions, File[] exclusions, IPublisherInfo publisherInfo, FileUtils.IPathComputer prefixComputer) {
        if (inclusions == null || inclusions.length < 1) {
            return;
        }
        IArtifactRepository destination = publisherInfo.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        if ((publisherInfo.getArtifactOptions() & 2) == 0) {
            destination.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        File tempFile = null;
        try {
            OutputStream output = destination.getOutputStream(descriptor);
            if (output == null) {
                return;
            }
            try {
                output = new BufferedOutputStream(output);
                tempFile = File.createTempFile("p2.generator", "");
                FileUtils.zip((File[])inclusions, (File[])exclusions, (File)tempFile, (FileUtils.IPathComputer)prefixComputer);
                if (output != null) {
                    FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(tempFile)), (boolean)true, (OutputStream)output, (boolean)true);
                }
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)e.getStatus());
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
                e.printStackTrace();
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    protected IInstallableUnit queryForIU(IPublisherResult publisherResult, String iuId, Version version) {
        IQuery query = QueryUtil.createIUQuery((String)iuId, (Version)version);
        if (version == null || Version.emptyVersion.equals(version)) {
            query = QueryUtil.createLatestQuery((IQuery)query);
        }
        Collector collector = Collector.emptyCollector();
        NullProgressMonitor progress = new NullProgressMonitor();
        if (publisherResult != null) {
            collector = publisherResult.query(query, (IProgressMonitor)progress);
        }
        if (collector.isEmpty() && this.info.getMetadataRepository() != null) {
            collector = this.info.getMetadataRepository().query(query, (IProgressMonitor)progress);
        }
        if (collector.isEmpty() && this.info.getContextMetadataRepository() != null) {
            collector = this.info.getContextMetadataRepository().query(query, (IProgressMonitor)progress);
        }
        if (!collector.isEmpty()) {
            return (IInstallableUnit)collector.iterator().next();
        }
        return null;
    }

    protected IQueryResult<IInstallableUnit> queryForIUs(IPublisherResult publisherResult, String iuId, VersionRange versionRange) {
        IQuery query = null;
        Collector queryResult = Collector.emptyCollector();
        query = QueryUtil.createIUQuery((String)iuId, (VersionRange)versionRange);
        NullProgressMonitor progress = new NullProgressMonitor();
        if (publisherResult != null) {
            queryResult = publisherResult.query(query, (IProgressMonitor)progress);
        }
        if (queryResult.isEmpty() && this.info.getMetadataRepository() != null) {
            queryResult = this.info.getMetadataRepository().query(query, (IProgressMonitor)progress);
        }
        if (queryResult.isEmpty() && this.info.getContextMetadataRepository() != null) {
            queryResult = this.info.getContextMetadataRepository().query(query, (IProgressMonitor)progress);
        }
        return queryResult;
    }

    @Override
    public abstract IStatus perform(IPublisherInfo var1, IPublisherResult var2, IProgressMonitor var3);

    public void setPublisherInfo(IPublisherInfo info) {
        this.info = info;
    }
}

