/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.util.Map;
import org.apache.lucene.analysis.pattern.SimplePatternSplitTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;

public class SimplePatternSplitTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "simplePatternSplit";
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int maxDeterminizedStates;

    public SimplePatternSplitTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxDeterminizedStates = this.getInt(args, "maxDeterminizedStates", 10000);
        this.dfa = Operations.determinize((Automaton)new RegExp(this.require(args, PATTERN)).toAutomaton(), (int)this.maxDeterminizedStates);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public SimplePatternSplitTokenizer create(AttributeFactory factory) {
        return new SimplePatternSplitTokenizer(factory, this.dfa);
    }
}

