/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.panes;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.registry.QueryObjectLink;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.actions.OpenHelpPageAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class QueryTextResultPane
extends AbstractEditorPane
implements ISelectionProvider,
LocationListener {
    private Browser browser;
    private Text text;
    private IStructuredSelection selection;
    private List<ISelectionChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    QueryContextMenu contextMenu;
    QueryResult queryResult;
    private Menu menu;
    static final int BROWSER_STYLE = 0;

    public void createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new FillLayout(512));
        try {
            this.browser = new Browser(top, 0);
            this.browser.addLocationListener((LocationListener)this);
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    QueryTextResultPane.this.getEditorSite().getActionBars().getStatusLineManager().setMessage(event.text);
                }
            });
            this.initialize(this.browser.getDisplay(), this.browser);
        }
        catch (SWTError e) {
            Text text1 = new Text(top, 2);
            text1.setText(MessageUtil.format((String)Messages.QueryTextResultPane_FailedBrowser, (Object[])new Object[]{e.getLocalizedMessage()}));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.report");
            this.text = new Text(top, 10);
            ErrorHelper.logThrowableAndShowMessage(e, MessageUtil.format((String)Messages.QueryTextResultPane_FailedBrowser2, (Object[])new Object[]{e.getLocalizedMessage()}));
        }
        this.contextMenu = new QueryContextMenu((AbstractEditorPane)this, new ContextProvider(null){

            public IContextObject getContext(Object obj) {
                return (IContextObject)obj;
            }
        });
    }

    void initialize(final Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (!event.required) {
                    return;
                }
                String urls = ((Browser)event.widget).getUrl();
                if (urls != null) {
                    try {
                        URL url = new URL(urls);
                        if (Program.launch((String)url.toString())) {
                            return;
                        }
                    }
                    catch (MalformedURLException url) {
                        // empty catch block
                    }
                }
                Shell shell = new Shell(display);
                shell.setImage(QueryTextResultPane.this.getTitleImage());
                shell.setText(Messages.QueryTextResultPane_BrowserTitle);
                shell.setLayout((Layout)new FillLayout());
                Browser browser = new Browser((Composite)shell, 0);
                browser.addLocationListener((LocationListener)QueryTextResultPane.this);
                QueryTextResultPane.this.initialize(display, browser);
                QueryTextResultPane.this.initialize2(display, browser);
                event.browser = browser;
            }
        });
    }

    void initialize2(Display display, Browser browser) {
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }

    @Override
    public void initWithArgument(Object argument) {
        block20: {
            if (!(argument instanceof QueryResult)) {
                return;
            }
            this.queryResult = (QueryResult)argument;
            if (this.queryResult.getSubject() instanceof TextResult) {
                TextResult textResult = (TextResult)this.queryResult.getSubject();
                if (textResult.isHtml()) {
                    if (this.browser != null) {
                        this.browser.setText(textResult.getText());
                    } else {
                        this.text.setText(textResult.getText());
                    }
                } else {
                    String html = "<pre>" + HTMLUtils.escapeText((String)textResult.getText()) + "</pre>";
                    if (this.browser != null) {
                        this.browser.setText(html);
                    } else {
                        this.text.setText(html);
                    }
                }
            } else if (this.queryResult.getSubject() instanceof DisplayFileResult) {
                try {
                    DisplayFileResult r = (DisplayFileResult)this.queryResult.getSubject();
                    if (this.browser != null) {
                        if (this.browser.getBrowserType().equals("ie") && this.darkMode()) {
                            File p = r.getFile().getParentFile();
                            File styles = new File(p, "styles.css");
                            File stylesDark = new File(p, "styles-dark.css");
                            if (styles.canWrite() && stylesDark.canRead()) {
                                try {
                                    Files.copy(stylesDark.toPath(), styles.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                                catch (IOException e) {
                                    ErrorHelper.logThrowableAndShowMessage(e);
                                }
                            }
                        }
                        this.browser.setUrl(r.getFile().toURI().toURL().toExternalForm());
                        break block20;
                    }
                    this.text.setText(r.getFile().toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    ErrorHelper.logThrowableAndShowMessage(e);
                }
            } else if (this.browser != null) {
                this.browser.setText(String.valueOf(this.queryResult.getSubject()));
            } else {
                this.text.setText(String.valueOf(this.queryResult.getSubject()));
            }
        }
        this.firePropertyChange(1);
    }

    boolean darkMode() {
        int bb;
        int bg;
        Color bgColor = this.browser.getBackground();
        int br = bgColor.getRed();
        return br * br + (bg = bgColor.getGreen()) * bg + (bb = bgColor.getBlue()) * bb < 49152;
    }

    @Override
    public void contributeToToolBar(IToolBarManager manager) {
        if (this.queryResult.getQuery() != null && this.queryResult.getQuery().getHelpUrl() != null) {
            manager.appendToGroup("help", (IAction)new OpenHelpPageAction(this.queryResult.getQuery().getHelpUrl()));
        }
        super.contributeToToolBar(manager);
    }

    @Override
    public void setFocus() {
        this.site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        this.site.getActionBars().updateActionBars();
        if (this.browser != null) {
            this.browser.setFocus();
        } else {
            this.text.setFocus();
        }
    }

    public ISelection getSelection() {
        return this.selection != null ? this.selection : StructuredSelection.EMPTY;
    }

    public void changing(LocationEvent event) {
        QueryObjectLink url = QueryObjectLink.parse((String)event.location);
        if (url == null) {
            return;
        }
        switch (url.getType()) {
            case OBJECT: {
                this.onObjectLinkEvent(event, url);
                break;
            }
            case QUERY: {
                this.onQueryLinkEvent(event, url);
                break;
            }
        }
    }

    private void onObjectLinkEvent(LocationEvent event, QueryObjectLink url) {
        try {
            final int objectId = this.getEditor().getQueryContext().mapToObjectId(url.getTarget());
            if (objectId < 0) {
                return;
            }
            this.selection = new StructuredSelection((Object)new IContextObject(){

                public int getObjectId() {
                    return objectId;
                }
            });
            for (ISelectionChangedListener l : new ArrayList<ISelectionChangedListener>(this.listeners)) {
                l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
            }
            PopupMenu m = new PopupMenu();
            this.contextMenu.addContextActions(m, this.selection, null);
            if (this.menu != null && !this.menu.isDisposed()) {
                this.menu.dispose();
            }
            this.menu = m.createMenu(this.getEditorSite().getActionBars().getStatusLineManager(), (Control)((Browser)event.widget));
            this.menu.setVisible(true);
        }
        catch (Exception e) {
            ErrorHelper.logThrowableAndShowMessage(e, MessageUtil.format((String)Messages.QueryTextResultPane_UnableToMapAddress, (Object[])new Object[]{url.getTarget()}));
        }
        event.doit = false;
    }

    private void onQueryLinkEvent(LocationEvent event, QueryObjectLink url) {
        try {
            ArgumentSet set = CommandLine.parse((IQueryContext)this.getQueryContext(), (String)url.getTarget());
            QueryExecution.execute(this.getEditor(), this.getPaneState(), null, set, false, true);
        }
        catch (SnapshotException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
        event.doit = false;
    }

    public void changed(LocationEvent event) {
    }

    public String getTitle() {
        return this.queryResult != null ? this.queryResult.getTitle() : Messages.QueryTextResultPane_Text;
    }

    @Override
    public Image getTitleImage() {
        Image image = this.queryResult != null ? MemoryAnalyserPlugin.getDefault().getImage(this.queryResult.getQuery()) : null;
        return image != null ? image : MemoryAnalyserPlugin.getImage("$nl$/icons/query_browser.gif");
    }

    @Override
    public String getTitleToolTip() {
        return this.queryResult != null ? this.queryResult.getTitleToolTip() : null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.queryResult.getClass())) {
            return adapter.cast(this.queryResult);
        }
        if (adapter.isAssignableFrom(this.queryResult.getSubject().getClass())) {
            return adapter.cast(this.queryResult.getSubject());
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }
}

