/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.Parameters;
import org.eclipse.mat.report.internal.PartsFactory;
import org.eclipse.mat.report.internal.ResultRenderer;
import org.eclipse.mat.util.IProgressListener;

public abstract class AbstractPart {
    protected final String id;
    protected final AbstractPart parent;
    protected final DataFile dataFile;
    protected final Spec spec;
    protected Parameters params;
    protected final List<AbstractPart> children;
    protected Map<String, Object> objects = new HashMap<String, Object>();
    protected ITestResult.Status status;

    protected AbstractPart(String id, AbstractPart parent, DataFile artefact, Spec spec) {
        this.id = id;
        this.parent = parent;
        this.dataFile = artefact;
        this.spec = spec;
        this.params = parent != null ? new Parameters.Deep(parent.params(), spec.getParams()) : new Parameters.Deep(spec.getParams());
        this.children = new ArrayList<AbstractPart>();
    }

    abstract void init(PartsFactory var1);

    public String getId() {
        return this.id;
    }

    public ITestResult.Status getStatus() {
        return this.status;
    }

    public AbstractPart getParent() {
        return this.parent;
    }

    DataFile getDataFile() {
        return this.dataFile;
    }

    public Spec spec() {
        return this.spec;
    }

    public Parameters params() {
        return this.params;
    }

    public Object getObject(String key) {
        return this.objects.get(key);
    }

    public Object putObject(String key, Object value) {
        return this.objects.put(key, value);
    }

    public List<AbstractPart> getChildren() {
        return this.children;
    }

    public String getCommand() {
        return null;
    }

    public abstract AbstractPart execute(IQueryContext var1, ResultRenderer var2, IProgressListener var3) throws SnapshotException, IOException;
}

