/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.progress;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCancelParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressKind;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.services.LanguageServer;

public class LSPProgressManager {
    private final Map<String, BlockingQueue<ProgressParams>> progressMap = new ConcurrentHashMap<String, BlockingQueue<ProgressParams>>();
    private final Map<IProgressMonitor, Integer> currentPercentageMap = new ConcurrentHashMap<IProgressMonitor, Integer>();
    private LanguageServer languageServer;
    private LanguageServersRegistry.LanguageServerDefinition languageServerDefinition;
    private final Set<String> done = new ConcurrentSkipListSet<String>();
    private final Set<Job> jobs = new ConcurrentSkipListSet<Job>();

    public void connect(LanguageServer languageServer, LanguageServersRegistry.LanguageServerDefinition languageServerDefinition) {
        this.languageServer = languageServer;
        this.languageServerDefinition = languageServerDefinition;
    }

    public @NonNull CompletableFuture<Void> createProgress(@NonNull WorkDoneProgressCreateParams params) {
        LinkedBlockingDeque<ProgressParams> queue = new LinkedBlockingDeque<ProgressParams>();
        String jobIdentifier = (String)params.getToken().map(Function.identity(), Object::toString);
        BlockingQueue oldQueue = this.progressMap.put(jobIdentifier, queue);
        if (oldQueue != null) {
            LanguageServerPlugin.logInfo("Old progress with identifier " + jobIdentifier + " discarded due to new create progress request");
        }
        this.createJob(queue, jobIdentifier);
        return CompletableFuture.completedFuture(null);
    }

    private void createJob(LinkedBlockingDeque<ProgressParams> queue, String jobIdentifier) {
        LanguageServer languageServer = this.languageServer;
        LanguageServersRegistry.LanguageServerDefinition languageServerDefinition = this.languageServerDefinition;
        String jobName = languageServerDefinition == null || languageServerDefinition.label == null || languageServerDefinition.label.isBlank() ? Messages.LSPProgressManager_BackgroundJobName : languageServerDefinition.label;
        Job job = Job.create((String)jobName, monitor -> {
            try {
                while (true) {
                    if (monitor.isCanceled()) {
                        this.progressMap.remove(jobIdentifier);
                        this.currentPercentageMap.remove(monitor);
                        if (languageServer != null) {
                            WorkDoneProgressCancelParams workDoneProgressCancelParams = new WorkDoneProgressCancelParams();
                            workDoneProgressCancelParams.setToken(jobIdentifier);
                            languageServer.cancelProgress(workDoneProgressCancelParams);
                        }
                        throw new OperationCanceledException();
                    }
                    ProgressParams nextProgressNotification = (ProgressParams)queue.pollFirst(1L, TimeUnit.SECONDS);
                    if (nextProgressNotification != null) {
                        WorkDoneProgressNotification progressNotification = (WorkDoneProgressNotification)nextProgressNotification.getValue().getLeft();
                        if (progressNotification == null) continue;
                        WorkDoneProgressKind kind = progressNotification.getKind();
                        if (kind == WorkDoneProgressKind.begin) {
                            this.begin((WorkDoneProgressBegin)progressNotification, monitor);
                            continue;
                        }
                        if (kind == WorkDoneProgressKind.report) {
                            this.report((WorkDoneProgressReport)progressNotification, monitor);
                            continue;
                        }
                        if (kind != WorkDoneProgressKind.end) continue;
                        this.end((WorkDoneProgressEnd)progressNotification, monitor);
                        this.progressMap.remove(jobIdentifier);
                        this.currentPercentageMap.remove(monitor);
                        return;
                    }
                    if (!this.done.remove(jobIdentifier)) continue;
                    monitor.done();
                }
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.jobs.add(job);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                LSPProgressManager.this.jobs.remove(event.getJob());
            }
        });
        job.schedule();
    }

    private void begin(WorkDoneProgressBegin begin, IProgressMonitor monitor) {
        Integer percentage = begin.getPercentage();
        if (percentage != null) {
            if (percentage == 0) {
                monitor.beginTask(begin.getTitle(), 100);
            } else {
                monitor.beginTask(begin.getTitle(), percentage.intValue());
            }
            this.currentPercentageMap.put(monitor, 0);
        } else {
            monitor.beginTask(begin.getTitle(), -1);
        }
        String message = begin.getMessage();
        if (message != null && !message.isBlank()) {
            monitor.subTask(message);
        }
    }

    private void end(WorkDoneProgressEnd end, IProgressMonitor monitor) {
        monitor.subTask(end.getMessage());
        monitor.done();
    }

    private void report(WorkDoneProgressReport report, IProgressMonitor monitor) {
        if (report.getMessage() != null && !report.getMessage().isBlank()) {
            monitor.subTask(report.getMessage());
        }
        if (report.getPercentage() != null) {
            if (this.currentPercentageMap.containsKey(monitor)) {
                Integer percentage = this.currentPercentageMap.get(monitor);
                int worked = percentage != null ? Math.min(percentage, report.getPercentage()) : 0;
                monitor.worked(report.getPercentage() - worked);
            }
            this.currentPercentageMap.put(monitor, report.getPercentage());
        }
    }

    public void notifyProgress(@NonNull ProgressParams params) {
        String jobIdentifier = (String)params.getToken().map(Function.identity(), Object::toString);
        BlockingQueue<ProgressParams> progress = this.progressMap.get(jobIdentifier);
        if (progress != null) {
            progress.add(params);
        } else {
            WorkDoneProgressNotification progressNotification = (WorkDoneProgressNotification)params.getValue().getLeft();
            if (progressNotification != null && progressNotification.getKind() == WorkDoneProgressKind.end) {
                this.done.add(jobIdentifier);
            }
        }
    }

    public void dispose() {
        this.jobs.forEach(Job::cancel);
        this.currentPercentageMap.clear();
        this.progressMap.clear();
        this.done.clear();
    }
}

