/*
 * Decompiled with CFR 0.152.
 */
package product;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValueType implements Enumerator
{
    STRING(0, "String", "String"),
    INTEGER(1, "Integer", "Integer"),
    BOOLEAN(2, "Boolean", "Boolean");

    public static final int STRING_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int BOOLEAN_VALUE = 2;
    private static final ValueType[] VALUES_ARRAY;
    public static final List<ValueType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValueType[]{STRING, INTEGER, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValueType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private ValueType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

