/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.scheduler.algorithm;

import activity.Activity;
import activity.ResourceAction;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import java.math.BigDecimal;
import lsat_graph.ActionTask;
import lsat_graph.DispatchGraph;
import org.eclipse.lsat.common.scheduler.graph.Constraint;
import org.eclipse.lsat.common.scheduler.graph.JitConstraint;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TimeConstraint;

public class ConstraintsUtil {
    private static final BigDecimal INFINITE_TIME_CONSTRAINT_UPPER_BOUND = BigDecimal.valueOf(1.0E99);

    private ConstraintsUtil() {
    }

    public static String constraintToString(Constraint constraint) {
        String source = ConstraintsUtil.getNodeName(constraint.getSource());
        String target = ConstraintsUtil.getNodeName(constraint.getTarget());
        if (constraint instanceof JitConstraint) {
            return source + " -jit-> " + target;
        }
        if (constraint instanceof TimeConstraint) {
            TimeConstraint timeConstraint = (TimeConstraint)constraint;
            if (timeConstraint.getUpperBound().compareTo(INFINITE_TIME_CONSTRAINT_UPPER_BOUND) == 0) {
                return source + " -> " + target;
            }
            return source + " -[" + timeConstraint.getLowerBound().toString() + "," + timeConstraint.getUpperBound().toString() + "]-> " + target;
        }
        return source + " -> " + target;
    }

    private static <T extends Task> String getNodeName(T node) {
        if (node instanceof ActionTask) {
            ActionTask task = (ActionTask)node;
            ResourceAction action = task.getAction();
            DispatchGraph dispatchGraph = (DispatchGraph)task.eContainer();
            Dispatch dispatch = dispatchGraph.getDispatch();
            String dispatchName = dispatch.getName();
            DispatchGroup dpGroup = (DispatchGroup)dispatch.eContainer();
            String dpGroupName = dpGroup.getName();
            Activity activity = dispatch.getActivity();
            Object result = "";
            if (dpGroupName != null && !dpGroupName.equals("default")) {
                result = dpGroupName + ".";
            }
            if (dispatchName != null && !dispatchName.startsWith("null")) {
                int lastUnderscore = dispatchName.lastIndexOf(95);
                dispatchName = lastUnderscore != -1 ? dispatchName.substring(0, lastUnderscore) : dispatchName;
                result = (String)result + dispatchName + ".";
            }
            return (String)result + activity.getName() + "." + action.getName();
        }
        return node.getName();
    }
}

